#include "DSound.h"
#include "DMusic.h"

//extern LPDIRECTSOUND8 lpDS; // DSound.cpp ǵ  


/*  ޼ҵ  */
DMusic::DMusic()
{
	dmPerf = NULL;		// the directmusic performance manager
	dmLoader = NULL;	// the directmusic loader
	dmActiveId = -1;	// currently active midi segment
	hr = NULL;
}


DMusic::~DMusic()
{
	// If there is any music playing, stop it. This is 
	// not really necessary, because the music will stop when
	// the instruments are unloaded or the performance is    
	// closed down.
	if (dmPerf) dmPerf->Stop(NULL, NULL, 0, 0); 

	// delete all the midis if they already haven't been
	deleteAllMIDI();

	// CloseDown and Release the performance object.
	if (dmPerf){
		dmPerf->CloseDown();
		dmPerf->Release();
	}

	// Release the loader object.
	if (dmLoader) dmLoader->Release();     

	// Release COM
	CoUninitialize(); 
}


BOOL DMusic::init(HWND hwnd)
{
	// this function initializes directmusic, it also checks if directsound has
	// been initialized, if so it connect the wave output to directsound, otherwise
	// it creates it's own directsound object, hence you must start directsound up
	// first if you want to use both directsound and directmusic

	int index;
	// set up directmusic, initialize COM
	if (FAILED(CoInitialize(NULL))) return FALSE; // Terminate the application

	// create the performance
	if (FAILED(CoCreateInstance(CLSID_DirectMusicPerformance,
		NULL,
		CLSCTX_INPROC,
		IID_IDirectMusicPerformance,
		(void**)&dmPerf))) return FALSE;

	// initialize the performance, check if directsound is on-line if so, use the
	// directsound object, otherwise create a new one
	if (FAILED(dmPerf->Init(NULL, lpDS, hwnd))) return FALSE; // Failure -- performance not initialized

	// add the port to the performance
	if (FAILED(dmPerf->AddPort(NULL))) return FALSE;// Failure -- port not initialized

	// create the loader to load object(s) such as midi file
	if (FAILED(CoCreateInstance(CLSID_DirectMusicLoader,
		NULL,
		CLSCTX_INPROC,
		IID_IDirectMusicLoader,
		(void**)&dmLoader))) return FALSE;

	// reset all the midi segment objects
	for (index = 0; index < DM_NUM_SEGMENTS; index++){
		dmMidi[index].dm_segment  = NULL;
		dmMidi[index].dm_segstate = NULL;
		dmMidi[index].state       = MIDI_NULL;
		dmMidi[index].id          = index;
    }

	// reset the active id
	dmActiveId = -1;
	// all good baby
	return TRUE;
}


int DMusic::loadMIDI(char *fileName) // this function loads a midi segment
{
	DMUS_OBJECTDESC ObjDesc;
	IDirectMusicSegment* pSegment = NULL;
	// look for open slot for midi segment
	int id = -1;
	for(int index = 0; index < DM_NUM_SEGMENTS; index++){
		// is this one open
		if (dmMidi[index].state == MIDI_NULL){
			// validate id, but don't validate object until loaded
			id = index;
			break;
		}
    }
	
	// found good id?
	if (id==-1) return(-1);
	
	// get current working directory
	char szDir[_MAX_PATH];
	WCHAR wszDir[_MAX_PATH];
	
	if(_getcwd( szDir, _MAX_PATH ) == NULL) return(-1);
	
	MULTI_TO_WIDE(wszDir, szDir);
	
	// tell the loader were to look for files
	hr = dmLoader->SetSearchDirectory(GUID_DirectMusicAllTypes,wszDir, FALSE);
	if (FAILED(hr)) return (-1);
	
	// convert fileName to wide string
	WCHAR wfileName[_MAX_PATH];
	MULTI_TO_WIDE(wfileName, fileName);
	
	// setup object description
	memset(&ObjDesc, 0, sizeof(ObjDesc));
	ObjDesc.guidClass = CLSID_DirectMusicSegment;
	wcscpy(ObjDesc.wszFileName, wfileName );
	ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_FILENAME;
	
	// load the object and query it for the IDirectMusicSegment interface
	// This is done in a single call to IDirectMusicLoader::GetObject
	// note that loading the object also initializes the tracks and does 
	// everything else necessary to get the MIDI data ready for playback.

	hr = dmLoader->GetObject(&ObjDesc, IID_IDirectMusicSegment, (void**)&pSegment);
	if (FAILED(hr)) return(-1);
 
	// ensure that the segment plays as a standard MIDI file
	// you now need to set a parameter on the band track
	// Use the IDirectMusicSegment::SetParam method and let 
	// DirectMusic find the trackby passing -1 (or 0xFFFFFFFF) in the dwGroupBits method parameter.

	hr = pSegment->SetParam(GUID_StandardMIDIFile,-1, 0, 0, (void*)dmPerf);
	if (FAILED(hr)) return(-1);
  
	// This step is necessary because DirectMusic handles program changes and 
	// bank selects differently for standard MIDI files than it does for MIDI 
	// content authored specifically for DirectMusic. 
	// The GUID_StandardMIDIFile parameter must be set before the instruments are downloaded. 

	// The next step is to download the instruments. 
	// This is necessary even for playing a simple MIDI file 
	// because the default software synthesizer needs the DLS data 
	// for the General MIDI instrument set
	// If you skip this step, the MIDI file will play silently.
	// Again, you call SetParam on the segment, this time specifying the GUID_Download parameter:

	hr = pSegment->SetParam(GUID_Download, -1, 0, 0, (void*)dmPerf);
	if (FAILED(hr)) return(-1);

	// at this point we have MIDI loaded and a valid object

	dmMidi[id].dm_segment  = pSegment;
	dmMidi[id].dm_segstate = NULL;
	dmMidi[id].state       = MIDI_LOADED;
 
	return(id); // return id
}

void DMusic::play(int id)
{
	// play sound based on id
	if (dmMidi[id].dm_segment && dmMidi[id].state!=MIDI_NULL){
		// if there is an active midi then stop it
		if (dmActiveId!=-1) stop(dmActiveId);
		// play segment and force tracking of state variable
		dmPerf->PlaySegment(dmMidi[id].dm_segment, 0, 0, &dmMidi[id].dm_segstate);
		dmMidi[id].state = MIDI_PLAYING;
		// set the active midi segment
		dmActiveId = id;
	}
}


void DMusic::stop(int id)
{
	// stop a midi segment
	if (dmMidi[id].dm_segment && dmMidi[id].state!=MIDI_NULL){
		// play segment and force tracking of state variable
		dmPerf->Stop(dmMidi[id].dm_segment, NULL, 0, 0);
		dmMidi[id].state = MIDI_STOPPED;
		// reset active id
		dmActiveId = -1;
	}
}


void DMusic::deleteMIDI(int id)
{
	// this function deletes one MIDI segment

	// Unload instruments this will cause silence.
	// CloseDown unloads all instruments, so this call is also not 
	// strictly necessary.
	if (dmMidi[id].dm_segment){
		dmMidi[id].dm_segment->SetParam(GUID_Unload, -1, 0, 0, (void*)dmPerf);
		// Release the segment and set to null
		dmMidi[id].dm_segment->Release();
		dmMidi[id].dm_segment  = NULL;
		dmMidi[id].dm_segstate = NULL;
		dmMidi[id].state       = MIDI_NULL;
	}
}


void DMusic::deleteAllMIDI()
{
	// delete all the MIDI 
	// free up all the segments
	for (int index = 0; index < DM_NUM_SEGMENTS; index++){
		// Unload instruments this will cause silence.
		// CloseDown unloads all instruments, so this call is also not
		// strictly necessary.
		if (dmMidi[index].dm_segment){
			dmMidi[index].dm_segment->SetParam(GUID_Unload, -1, 0, 0, (void*)dmPerf);
			// Release the segment and set to null
			dmMidi[index].dm_segment->Release();
			dmMidi[index].dm_segment  = NULL;
			dmMidi[index].dm_segstate = NULL;
			dmMidi[index].state       = MIDI_NULL;
		}
    }
}


int DMusic::getStatusMIDI(int id) // this checks the status of a midi segment
{
	if (dmMidi[id].dm_segment && dmMidi[id].state !=MIDI_NULL ){
		// get the status and translate to our defines
		if (dmPerf->IsPlaying(dmMidi[id].dm_segment,NULL) == S_OK) dmMidi[id].state = MIDI_PLAYING;
		else dmMidi[id].state = MIDI_STOPPED;
		return(dmMidi[id].state);
	}
	else return(0);
}
