#ifndef __DMusic_h_included__
#define __DMusic_h_included__

#include "dx.h"
#include "c:\Dxsdk\include\dmksctrl.h"
#include "c:\Dxsdk\include\dmusici.h"
#include "c:\Dxsdk\include\dmusicc.h"
#include "c:\Dxsdk\include\dmusicf.h"

// DEFINES ////////////////////////////////////////////////

#define DM_NUM_SEGMENTS 64 // number of midi segments that can be cached in memory
#define MIDI_NULL     0   // this midi object is not loaded
#define MIDI_LOADED   1   // this midi object is loaded
#define MIDI_PLAYING  2   // this midi object is loaded and playing
#define MIDI_STOPPED  3   // this midi object is loaded, but stopped

// MACROS /////////////////////////////////////////////////

#define MULTI_TO_WIDE( x,y )  MultiByteToWideChar( CP_ACP,MB_PRECOMPOSED, y,-1,x,_MAX_PATH);

// TYPES //////////////////////////////////////////////////

// directmusic MIDI segment
typedef struct DM_MIDI_TYP
{
	IDirectMusicSegment        *dm_segment;  // the directmusic segment
	IDirectMusicSegmentState   *dm_segstate; // the state of the segment
	int id;                                  // the id of this segment
	int state;                               // state of midi song
} DmMidi, *DmMidiPtr;


/* ̷Ʈ  Ŭ */
class DMusic
{
private:
	// direct music globals
	IDirectMusicPerformance *dmPerf; // the directmusic performance manager
	IDirectMusicLoader *dmLoader; // the directmusic loader
	
	// this hold all the directmusic midi objects
	DmMidi dmMidi[DM_NUM_SEGMENTS];
	int dmActiveId; // currently active midi segment
	HRESULT hr;

public:
	DMusic();
	~DMusic();
	BOOL init(HWND hwnd);
	int loadMIDI(char *fileName);
	void play(int id);
	void stop(int id);
	void deleteMIDI(int id);
	void deleteAllMIDI();
	int getStatusMIDI(int id);
};

#endif