#include "DSound.h"


// ̷Ʈ   
LPDIRECTSOUND8		lpDS;           // directsound interface pointer
//DSCAPS				dscaps;         // directsound caps
//DSBCAPS				dsbcaps;        // directsound buffer caps
//LPDIRECTSOUNDBUFFER	lpdsbprimary;   // the primary mixing buffer


/*  ޼ҵ  */
DSound::DSound()
{
	lpDS = NULL;
	memset(&wfx, 0, sizeof(wfx));
	memset(&dsbd, 0, sizeof(dsbd));
	// set up the format data structure
	wfx.wFormatTag = WAVE_FORMAT_PCM; // pulse code modulation
	wfx.nChannels = 1; // mono
	wfx.nSamplesPerSec = 22050; // always this rate
	wfx.wBitsPerSample = 16;
    wfx.nBlockAlign = wfx.wBitsPerSample / 8 * wfx.nChannels;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
	wfx.cbSize = 0;
}


DSound::~DSound()
{
	stopAll();
	for (int index=0; index<MAX_SOUNDS; index++)
		if (soundFX[index].DSBuffer) soundFX[index].DSBuffer->Release();
	lpDS->Release(); // now release the directsound interface itself
}


BOOL DSound::init(HWND hwnd)
{
	static int first_time = 1;
	
	if (first_time){ // clear everything out
		memset(soundFX, 0, sizeof(PcmSound)*MAX_SOUNDS);
		first_time = 0;
		// create a directsound object
		if (FAILED(DirectSoundCreate8(NULL, &lpDS, NULL))) return FALSE;
		// set cooperation level
		if (FAILED(lpDS->SetCooperativeLevel(hwnd, DSSCL_PRIORITY))) return FALSE;
	}
	
	// initialize the sound fx array
	for (int index=0; index<MAX_SOUNDS; index++){
		// test if this sound has been loaded
		if (soundFX[index].DSBuffer){
			soundFX[index].DSBuffer->Stop(); // stop the sound
			soundFX[index].DSBuffer->Release(); // release the buffer
		}
		memset(&soundFX[index], 0, sizeof(PcmSound)); // clear the record out
		// now set up the fields
		soundFX[index].state = SOUND_NULL;
		soundFX[index].id    = index;
	}
	return TRUE;
}


int DSound::loadWAV(char *filename, int controlFlags)
{
	// this function loads a .wav file, sets up the directsound 
	// buffer and loads the data into memory, the function returns 
	// the id number of the sound

	HMMIO 			hwav; // handle to wave file
	MMCKINFO		parentChunk, childChunk; // parent chunk, child chunk
	static int bufferSize, formatSize;
	
	int	sound_id = -1, index; // id of sound to be loaded, looping variable

	UCHAR *soundBuffer, // temporary sound buffer to hold voc data
		*audioPtr1 = NULL, // data ptr to first write buffer
		*audioPtr2 = NULL; // data ptr to second write buffer
	DWORD audioBytes1 = 0, // length of first write buffer
		audioBytes2 = 0; // length of second write buffer
	
	// step one: are there any open id's ?
	for (index=0; index < MAX_SOUNDS; index++){
		// make sure this sound is unused
		if (soundFX[index].state==SOUND_NULL){
			sound_id = index;
			break;
		}
	}

	// did we get a free id?
	if (sound_id==-1) return (-1);

	// open the WAV file
	if (!(hwav = mmioOpen(filename, NULL, MMIO_READ | MMIO_ALLOCBUF))) return (-1);

	// descend into the RIFF
	parentChunk.fccType = mmioFOURCC('W', 'A', 'V', 'E');
	if (mmioDescend(hwav, &parentChunk, NULL, MMIO_FINDRIFF)){
		mmioClose(hwav, 0); // close the file
		return (-1); // return error, no wave section
    }

	// descend to the WAVEfmt
	childChunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
	if (mmioDescend(hwav, &childChunk, &parentChunk, MMIO_FINDCHUNK)){
		mmioClose(hwav, 0); // close the file
		return (-1); // return error, no format section
	}

	formatSize = childChunk.cksize;
	
	// now read the wave format information from file
	if (mmioRead(hwav, (HPSTR)&wfx, formatSize) != formatSize){
		mmioClose(hwav, 0); // close file
		return (-1); // return error, no wave format data
	}
	
	// make sure that the data format is PCM
	if (wfx.wFormatTag != WAVE_FORMAT_PCM){
		mmioClose(hwav, 0); // close the file
		return (-1); // return error, not the right data format
	}
	
	// now ascend up one level, so we can access data chunk
	if (mmioAscend(hwav, &childChunk, 0)){
		mmioClose(hwav, 0); // close file
		return (-1); // return error, couldn't ascend
	}
	
	// descend to the data chunk
	childChunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
	if (mmioDescend(hwav, &childChunk, &parentChunk, MMIO_FINDCHUNK)){
		mmioClose(hwav, 0); // close file
		return (-1); // return error, no data
    }
	
	// finally!!!! now all we have to do is read the data in and
	// set up the directsound buffer

	bufferSize = childChunk.cksize;
	
	soundBuffer = (UCHAR *)malloc(bufferSize); // allocate the memory to load sound data
	// read the wave data
	if(mmioRead(hwav, (HPSTR)soundBuffer, bufferSize) != bufferSize){
		mmioClose(hwav, 0);
		return (-1);
	}
	mmioClose(hwav, 0); // close the file

	// set rate and size in data structure
	soundFX[sound_id].rate  = wfx.nSamplesPerSec;
	soundFX[sound_id].size  = bufferSize;
	soundFX[sound_id].state = SOUND_LOADED;
	
	// prepare to create sounds buffer
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize			= sizeof(DSBUFFERDESC);
	dsbd.dwFlags		= controlFlags | DSBCAPS_STATIC | DSBCAPS_LOCSOFTWARE;
	dsbd.dwBufferBytes	= bufferSize;
	dsbd.lpwfxFormat	= &wfx;
	
	// create the sound buffer
	if (FAILED(lpDS->CreateSoundBuffer(&dsbd,&soundFX[sound_id].DSBuffer,NULL))){
		free(soundBuffer); // release memory
		return (-1); // return error
	}
	
	// copy data into sound buffer
	if (FAILED(soundFX[sound_id].DSBuffer->Lock(0,	bufferSize, 
		(void **)&audioPtr1, &audioBytes1,
		(void **)&audioPtr2, &audioBytes2, DSBLOCK_FROMWRITECURSOR))) return (-1);
	
	// copy first section of circular buffer
	memcpy(audioPtr1, soundBuffer, audioBytes1);
	
	// copy last section of circular buffer
	if(audioBytes2)	memcpy(audioPtr2, soundBuffer+audioBytes1, audioBytes2);
	
	// unlock the buffer
	if (FAILED(soundFX[sound_id].DSBuffer->Unlock(audioPtr1, audioBytes1,
		audioPtr2, audioBytes2))) return (-1);
	
	free(soundBuffer); // release the temp buffer
	return(sound_id); // return id
}


int DSound::replicateSound(int source_id)
{
	// this function replicates the sent sound and sends back the
	// id of the replicated sound, you would use this function
	// to make multiple copies of a gunshot or something that
	// you want to play multiple times simulataneously, but you
	// only want to load once
	if (source_id!=-1){
		// duplicate the sound buffer
		// first hunt for an open id
		for (int id=0; id < MAX_SOUNDS; id++){
			// is this sound open?
			if (soundFX[id].state==SOUND_NULL){
				// first make an identical copy
				soundFX[id] = soundFX[source_id];
				// now actually replicate the directsound buffer
				if (FAILED(lpDS->DuplicateSoundBuffer(soundFX[source_id].DSBuffer, &soundFX[id].DSBuffer))){
					// reset sound to NULL
					soundFX[id].DSBuffer = NULL;
					soundFX[id].state    = SOUND_NULL;
					return (-1); // return error
				}
				soundFX[id].id = id; // now fix up id
				return(id); // return replicated sound
            }
        }
	}
	return (-1); // else failure
}


BOOL DSound::play(int id, int flags, int volume, int rate, int pan)
{
	if (soundFX[id].DSBuffer){
		// reset position to start
		if (FAILED(soundFX[id].DSBuffer->SetCurrentPosition(0))) return FALSE;
		// play sound
		if (FAILED(soundFX[id].DSBuffer->Play(0,0,flags))) return FALSE;
	}
	return TRUE;
}


void DSound::stop(int id)
{
	if (soundFX[id].DSBuffer){
		soundFX[id].DSBuffer->Stop();
		soundFX[id].DSBuffer->SetCurrentPosition(0);
	}
}


void DSound::stopAll()
{
	for (int index=0; index<MAX_SOUNDS; index++) stop(index);
}


BOOL DSound::setVolume(int id, int vol) // this function sets the volume on a sound 0-100
{
	if (soundFX[id].DSBuffer->SetVolume(DSVOLUME_TO_DB(vol))!=DS_OK) return FALSE;
	return TRUE;
}


BOOL DSound::setFreq(int id, int freq) // this function sets the playback rate
{
	if (soundFX[id].DSBuffer->SetFrequency(freq)!=DS_OK) return FALSE;
	return TRUE;
}


BOOL DSound::setPan(int id, int pan) // this function sets the pan, -10,000 to 10,000
{
	if (soundFX[id].DSBuffer->SetPan(pan)!=DS_OK) return FALSE;
	return TRUE;
}


int DSound::getStatusSound(int id) // this function returns the status of a sound
{
	if (soundFX[id].DSBuffer){
		ULONG status;
		// get the status
		soundFX[id].DSBuffer->GetStatus(&status);
		// return the status
		return(status);
	}
	else return (-1); // total failure
}


BOOL DSound::isPlaying(int id)
{
	if(getStatusSound(id)==DSBSTATUS_PLAYING) return TRUE;
	return FALSE;
}
