#ifndef __DSound_h_included__
#define __DSound_h_included__

#include "dx.h"
#include "c:\Dxsdk\include\dsound.h"


//  
extern LPDIRECTSOUND8 lpDS;

// DEFINES
#define DSBCAPS_CTRLDEFAULT (DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY)

#define MAX_SOUNDS     256 // max number of sounds in system at once 

#define SOUND_NULL     0
#define SOUND_LOADED   1
//#define SOUND_PLAYING  2
//#define SOUND_STOPPED  3

// MACROS

#define DSVOLUME_TO_DB(volume) ((DWORD)(-30*(100 - volume)))

// TYPES

// this holds a single sound
typedef struct PCM_SOUND_TYP
{
	LPDIRECTSOUNDBUFFER DSBuffer;	// the ds buffer containing the sound
	int state;	// state of the sound
	int rate;	// playback rate
	int size;	// size of sound
	int id;		// id number of the sound
} PcmSound, *PcmSoundPtr;


/* ̷Ʈ  Ŭ */
class DSound
{
private:
	PcmSound			soundFX[MAX_SOUNDS]; // the array of secondary sound buffers
	WAVEFORMATEX		wfx; // generic waveformat structure
	DSBUFFERDESC		dsbd; // directsound description
	//BOOL soundInit;

public:
	DSound();
	~DSound();
	BOOL init(HWND hwnd);
	int loadWAV(char *filename, int controlFlags = DSBCAPS_CTRLDEFAULT);
	int replicateSound(int sourceId);
	BOOL play(int id, int flags = 0, int volume = 0, int rate = 0, int pan = 0);
	void stop(int id);
	void stopAll();
	BOOL setVolume(int id,int vol);
	BOOL setFreq(int id,int freq);
	BOOL setPan(int id, int pan);
	int getStatusSound(int id);
	BOOL isPlaying(int id);
};

#endif