#include "Math.h"

float cos_ref[360] = {0}; // Cosine  ̺
float sin_ref[360] = {0}; // Sine  ̺


void buildSinCosTable()
{
	// create sin/cos lookup table
	
	// generate the tables
	for (int ang = 0; ang < 360; ang++)
	{
		// convert ang to radians
		float theta = (float)ang*PI/(float)180;
		// insert next entry into table
		cos_ref[ang] = (float)cos(theta);
		sin_ref[ang] = (float)sin(theta);
    }
}


char *toString(int n, int m) // int  ڿ ȯ (, ڸ)
{
	static char tempStr[MAX_BUFFER], toStr[MAX_BUFFER], na;
	static int i;

	if(m<0 || m>MAX_BUFFER) return NULL;

	i = 0;
	while(n){
		na = n%10;
		n /= 10;
		tempStr[i] = na + '0';
		if(++i>=MAX_BUFFER) break;
	}

	for(n=0; n<(m-i); n++){
		toStr[n] = ' ';
	}

	while(i){
		--i;
		toStr[n] = tempStr[i];
		++n;
	}
	toStr[n] = NULL;
	return toStr;
}
