#include "Sprite.h"

// DDraw.cpp ǵ  
//extern LPDIRECTDRAW7 lpDD;
//extern LPDIRECTDRAWSURFACE7 lpDDSBack;
//extern DDSURFACEDESC2 ddsd;
//extern DDCOLORKEY colorKey;
//extern int screenWidth;
//extern int screenHeight;
//extern int sx_clip, sy_clip, ex_clip, ey_clip;


// Static 
int Sprite::sx = 0;
int Sprite::sy = 0;
int Sprite::ex = 0;
int Sprite::ey = 0;
int Sprite::w1 = 0;
int Sprite::w2 = 0;
int Sprite::h1 = 0;
int Sprite::h2 = 0;
int Sprite::dx = 0;
int Sprite::dy = 0;
int Sprite::startX = 0;
int Sprite::startY = 0;
RECT Sprite::sourceRect = {0, 0, 0, 0};


/*  ޼ҵ  */
Sprite::Sprite()
{
	x = y = oldX = oldY = xv = yv = 0;
	state = SPRITE_STATE_DEAD;
	width = 0;
	height = 0;
	startX = startY = 0;
	count = 0;
	// Ӱ  ʱȭ
	for(int i=0; i < MAX_ANI; i++){
		for(int i2 = 0; i2 < MAX_FRAME; i2++) frameBuffer[i][i2] = NULL;
		numFrames[i] = 0;
	}
	currAni = 0;
	currFrame = 0;
	delay = delayCount = 0;
	hasRealFrames = FALSE;
}


Sprite::Sprite(int width, int height)
{
	x = y = oldX = oldY = xv = yv = 0;
	state = SPRITE_STATE_DEAD;
	this->width = width;
	this->height = height;
	startX = startY = 0;
	count = 0;
	// Ӱ  ʱȭ
	for(int i=0; i < MAX_ANI; i++){
		for(int i2 = 0; i2 < MAX_FRAME; i2++) frameBuffer[i][i2] = NULL;
		numFrames[i] = 0;
	}
	currAni = 0;
	currFrame = 0;
	delay = delayCount = 0;
	hasRealFrames = FALSE;
}


Sprite::~Sprite()
{
	//   
	if(hasRealFrames){
		for(int i=0; i < MAX_ANI; i++){
			for(int i2=0; i2 < MAX_FRAME; i2++){
				if(frameBuffer[i][i2]){
						frameBuffer[i][i2]->Release();
						frameBuffer[i][i2] = NULL;
				}
			}
		}
	}
}


LPDIRECTDRAWSURFACE7 Sprite::createOffScreen() // Ʈ  ũ !
{
	LPDIRECTDRAWSURFACE7 lpOffscreen; // ũ 
	memset(&ddsd, 0, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;
	ddsd.dwHeight = height;
	ddsd.dwWidth = width;
	if(FAILED(lpDD->CreateSurface(&ddsd, &lpOffscreen, NULL))) return NULL;
	// set color key to color 0
    colorKey.dwColorSpaceLowValue  = 0;
    colorKey.dwColorSpaceHighValue = 0;
    // now set the color key for source blitting
    lpOffscreen->SetColorKey(DDCKEY_SRCBLT, &colorKey);
	return lpOffscreen;
}


BOOL Sprite::loadFrame(BMP *bmp, int ani, int cellx, int celly, int cell_mode)
{
	// Ʈ ۰ ִ,   á ˻
	LPDIRECTDRAWSURFACE7 bmpBuffer = bmp->getBuffer(); // Ʈ ǥ .
	if((bmpBuffer == NULL) || (numFrames[ani] >= MAX_FRAME)) return FALSE;

	// ̹   ǥ(ũ)
	if((frameBuffer[ani][numFrames[ani]] = createOffScreen())==NULL) return FALSE;

	if (cell_mode)
	{
		cellx = cellx*(width+1) + startX + 1;
		celly = celly*(height+1) + startY + 1;
	}

	SetRect(&sourceRect, cellx, celly, cellx+width, celly+height);
	frameBuffer[ani][numFrames[ani]]->BltFast(0, 0, bmpBuffer, &sourceRect, DDBLTFAST_NOCOLORKEY|DDBLTFAST_WAIT);

	++numFrames[ani]; // Ӽ  
	hasRealFrames = TRUE;

	return TRUE;
}


BOOL Sprite::loadFrames(BMP *bmp, int ani, int x, int y, int numFrames)
{
	for(int index=0; index < numFrames; index++){
		if(!loadFrame(bmp, ani, x + index, y, 1)) return FALSE;
	}
	return TRUE;
}


BOOL Sprite::getFrames(Sprite *sp) // ٸ Ʈ ̹() 
{
	if(hasRealFrames) return FALSE;
	hasRealFrames = FALSE;

	for(int i=0; i < MAX_ANI; i++){
		for(int i2=0; i2 < MAX_FRAME; i2++){
			frameBuffer[i][i2] = sp->frameBuffer[i][i2];
		}
		numFrames[i] = sp->numFrames[i];
	}
	currFrame = sp->currFrame;

	width = sp->width;
	height = sp->height;
	return TRUE;
}


void Sprite::setLoadPos(int x, int y) // Ʈ ̹   о  ġ 
{
	startX = x;
	startY = y;
}


void Sprite::renderFrame() //   ̹ ׸
{
	if(currFrame >= numFrames[currAni]) currFrame = 0;

	if(frameBuffer[currAni][currFrame]){
		sourceRect.left = 0;
		sourceRect.top = 0;
		sourceRect.right = width;
		sourceRect.bottom = height;
		lpDDSBack->BltFast(x, y, frameBuffer[currAni][currFrame], &sourceRect,  DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
	}
	if(++delayCount>delay){
		delayCount = 0;
		++currFrame;
	}
}


void Sprite::renderFrame(int index) //   ̹ ׸
{
	if(index < 0) return;

	sourceRect.left = 0;
	sourceRect.top = 0;
	sourceRect.right = width;
	sourceRect.bottom = height;

	if(index >= numFrames[currAni]) index = numFrames[currAni] - 1;
	if(frameBuffer[currAni][index]){
		lpDDSBack->BltFast(x, y, frameBuffer[currAni][index], &sourceRect,  DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
	}
}


void Sprite::renderFrameClip() //   ̹ ׸(Ŭ )
{
	sx = x;
	sy = y;
	ex = x+width;
	ey = y+height;
	if(sx>ex_clip || sy>ey_clip) return;
	if(ex<sx_clip || ey<sy_clip) return;

	sourceRect.left = 0;
	sourceRect.top = 0;
	sourceRect.right = width;
	sourceRect.bottom = height;

	if(sx<sx_clip){
		sx = sx_clip;
		sourceRect.left = sx_clip - x;
	}
	if(sy<sy_clip){
		sy = sy_clip;
		sourceRect.top = sy_clip - y;
	}
	if(ex>ex_clip){
		sourceRect.right = ex_clip - x;
	}
	if(ey>ey_clip){
		sourceRect.bottom = ey_clip - y;
	}

	if(currFrame >= numFrames[currAni]) currFrame = 0;
	if(frameBuffer[currAni][currFrame]){
		lpDDSBack->BltFast(sx, sy, frameBuffer[currAni][currFrame], &sourceRect,  DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
	}
	if(++delayCount>delay){
		delayCount = 0;
		++currFrame;
	}
}


void Sprite::renderFrameClip(int index) //   ̹ ׸(Ŭ )
{
	if(index < 0) return;
	sx = x;
	sy = y;
	ex = x+width;
	ey = y+height;
	if(sx>ex_clip || sy>ey_clip) return;
	if(ex<sx_clip || ey<sy_clip) return;

	sourceRect.left = 0;
	sourceRect.top = 0;
	sourceRect.right = width;
	sourceRect.bottom = height;

	if(sx<sx_clip){
		sx = sx_clip;
		sourceRect.left = sx_clip - x;
	}
	if(sy<sy_clip){
		sy = sy_clip;
		sourceRect.top = sy_clip - y;
	}
	if(ex>ex_clip){
		sourceRect.right = ex_clip - x;
	}
	if(ey>ey_clip){
		sourceRect.bottom = ey_clip - y;
	}

	if(index >= numFrames[currAni]) index = numFrames[currAni] - 1;
	if(frameBuffer[currAni][index]){
		lpDDSBack->BltFast(sx, sy, frameBuffer[currAni][index], &sourceRect,  DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT);
	}
}


void Sprite::renderFrameFast() //   ̹ ׸
{
	if(currFrame >= numFrames[currAni]) currFrame = 0;

	if(frameBuffer[currAni][currFrame]){
		sourceRect.left = 0;
		sourceRect.top = 0;
		sourceRect.right = width;
		sourceRect.bottom = height;

		lpDDSBack->BltFast(x, y, frameBuffer[currAni][currFrame], &sourceRect,  DDBLTFAST_NOCOLORKEY | DDBLTFAST_WAIT);
	}
	if(++delayCount>delay){
		delayCount = 0;
		++currFrame;
	}
}


void Sprite::renderFrameFast(int index) //   ̹ ׸
{
	if(index < 0) return;

	sourceRect.left = 0;
	sourceRect.top = 0;
	sourceRect.right = width;
	sourceRect.bottom = height;

	if(index >= numFrames[currAni]) index = numFrames[currAni] - 1;
	if(frameBuffer[currAni][index]){
		lpDDSBack->BltFast(x, y, frameBuffer[currAni][index], &sourceRect,  DDBLTFAST_NOCOLORKEY | DDBLTFAST_WAIT);
	}
}



int Sprite::getX()
{
	return x;
}


int Sprite::getY()
{
	return y;
}


void Sprite::setPos(int x, int y) // ġ 
{
	this->x = x;
	this->y = y;
}


void Sprite::backupPos()
{
	oldX = x;
	oldY = y;
}


void Sprite::restorePos()
{
	x = oldX;
	y = oldY;
}


void Sprite::setSize(int width, int height) //   
{
	this->width = width;
	this->height = height;
}


void Sprite::setState(int state)
{
	this->state = state;
}


void Sprite::setAni(int ani)
{
	if(ani<0 || ani>=MAX_ANI ) ani = 0;
	currAni = ani;
}


void Sprite::setDelay(int d)
{
	delay = d;
}


void Sprite::move() // ̵
{
	x += xv;
	y += yv;
}


BOOL Sprite::testCollision(Sprite *sp) // 浹üũ
{
	if(sp==this) return FALSE;
	
	w1 = width>>1;
	h1 = height>>1;
	w2 = sp->width>>1;
	h2 = sp->height>>1;
	dx = (x+w1) - (sp->x+w2);
	dy = (y+h1) - (sp->y+h2);
	if(dx < 0) dx = -dx;
	if(dy < 0) dy = -dy;

	if(dx >= w1+w2) return FALSE;
	if(dy >= h1+h2) return FALSE;
	return TRUE;
}
