#ifndef __Sprite_h_included__
#define __Sprite_h_included__

#include "DDraw.h"
#include "BMP.h"


/* Ʈ  */
const int MAX_ANI = 4;		// ִϸ̼: ̵ (,,,)
const int MAX_FRAME = 18;	//   ִ  
							//  MAX_ANI*MAX_FRAME   

/* Ʈ ⺻  */
const int SPRITE_STATE_DEAD = 0;
const int SPRITE_STATE_ALIVE = 1;
const int SPRITE_STATE_DYING = 2;

/* Ʈ ⺻  */
const int SPRITE_DIR_RIGHT = 0;	// 
const int SPRITE_DIR_UP = 1;	// 
const int SPRITE_DIR_LEFT = 2;	// 
const int SPRITE_DIR_DOWN = 3;	// 


/* Ʈ Ŭ */
class Sprite
{
public: // Ʈ Ϲ 
	int id;			// Ʈ ⺻ ĺ
	int state;		// ׾? Ҵ?
	int width, height;		// , 
	int x, y, oldX, oldY;	// Ʈ ġ
	int xv, yv;		// ̵ӵ
	int count;		//  īƮ

protected: // Ӱ 
	LPDIRECTDRAWSURFACE7 frameBuffer[MAX_ANI][MAX_FRAME]; // Ʈ ǥ
	int numFrames[MAX_ANI]; // ִϸ̼ǿ     
	int currAni;			//  ִϸ̼
	int currFrame;			//  ǥõǴ 
	int delay, delayCount;	//   Ѿ  Ű  īƮ
	BOOL hasRealFrames;

public: // static 
	static int sx, sy, ex, ey;			// Ŭ  
	static int w1, w2, h1, h2, dx, dy;	// 浹 ˻  
	static int startX, startY;			//  о  ǥ
	static RECT sourceRect;				// ӹ ҽ

public:
	Sprite();
	Sprite(int width, int height);
	~Sprite();
	//   ޼ҵ
	LPDIRECTDRAWSURFACE7 createOffScreen(); // Ʈ  ũ ǥ
	BOOL loadFrame(BMP *bmp, int ani, int cellx, int celly, int cell_mode = 1); // Ʈ̹ Ʈ ̹ 
	BOOL loadFrames(BMP *bmp, int ani, int x, int y, int num_frames); //    ŭ ѹ о
	BOOL getFrames(Sprite *sp); // Ӱ  
	static void setLoadPos(int x, int y); //  о  ġ 
	void renderFrame();					//   
	void renderFrame(int index);		// index°  
	void renderFrameClip();				//Ŭ 
	void renderFrameClip(int index);
	void renderFrameFast();				//   
	void renderFrameFast(int index);	// index°  
	// Ʈ Ϲ ޼ҵ
	int getX();
	int getY();
	void setPos(int x, int y); // ġ 
	void backupPos();	// ġ 
	void restorePos();	// ġ 
	void setSize(int width, int height); //   
	void setState(int state); //  
	void setAni(int ani);
	void setDelay(int d);
	void move(); // ̵
	BOOL testCollision(Sprite *sp); // 浹üũ
};

#endif
