/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 Ӱ    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "component.h"
#include "..\sound.h"


DInput *Component::dinput = NULL;
Font *Component::font = NULL;
int Component::fontWidth = 0;
int Component::fontHeight = 0;


Component::Component()
{
	x = y = 0;
	width = height = 0;
	rectX = rectY = rectWidth = rectHeight = 0;
	label = NULL;
	isVisible = TRUE;
}


Component::~Component()
{
	;
}


BOOL Component::setDInput(DInput *di)
{
	if(di){
		Component::dinput = di;
		return TRUE;
	}
	return FALSE;
}


BOOL Component::setFont(Font *font)
{
	if(!font) return FALSE;
	Component::font = font;
	fontWidth = font->width;
	fontHeight = font->height;
	return TRUE;
}


void Component::setLabel(char *s)
{
	if(s){
		label = s;
		rectWidth = strlen(s)*font->width;
		rectHeight = font->height;
	}
}


void Component::setRect(int x, int y, int width, int height)
{
	rectX = x;
	rectY = y;
	rectWidth = width;
	rectHeight = height;
}


void Component::setVisible(BOOL b)
{
	isVisible = b;
}


BOOL Component::isClicked()
{
	static int mx, my;
	if(dinput->mouseStateLB==MOUSE_CLICKED && isVisible){
		mx = dinput->mouseX;
		my = dinput->mouseY;
		rectX = x;
		rectY = y;
		if((mx>rectX && mx<rectX+rectWidth)&&(my>rectY && my<rectY+rectHeight)){
			playSound(SOUND_DEFAULT);
			return TRUE;
		}
		if((mx>x && mx<x+width)&&(my>y && my<y+height)){
			playSound(SOUND_DEFAULT);
			return TRUE;
		}
	}
	return FALSE;
}


BOOL Component::isDragged()
{
	static int mx, my;
	if(dinput->mouseStateLB==MOUSE_DRAGGED && isVisible){
		mx = dinput->mouseX;
		my = dinput->mouseY;
		rectX = x;
		rectY = y;
		if((mx>rectX && mx<rectX+rectWidth)&&(my>rectY && my<rectY+rectHeight)) return TRUE;
		if((mx>x && mx<x+width)&&(my>y && my<y+height)) return TRUE;
	}
	return FALSE;
}


BOOL Component::isPressed()
{
	static int mx, my;
	if(dinput->mouseStateLB==MOUSE_PRESSED && isVisible){
		mx = dinput->mouseX;
		my = dinput->mouseY;
		rectX = x;
		rectY = y;
		if((mx>rectX && mx<rectX+rectWidth)&&(my>rectY && my<rectY+rectHeight)) return TRUE;
		if((mx>x && mx<x+width)&&(my>y && my<y+height)) return TRUE;
	}
	return FALSE;
}
