/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "dx\DDraw.h"
#include "dx\DInput.h"
#include "dx\Sprite.h"
#include "GameCredit.h"
#include "pacman.h"
#include "sound.h"
#include "font.h"
#include "mouse.h"
#include "particle.h"


// ܺ  
extern DDraw *ddraw;
extern DInput *dinput;
extern WORD g_key;
extern Font *font;
extern Font *font16;
extern Mouse *mouse;
extern Sprite *title;


#define CREDIT_ROW	9

// 
const int TITLE_X = (SCREEN_WIDTH - TITLE_WIDTH)>>1;
const int TITLE_Y = 0;

const int CREDIT_HEIGHT = 24*CREDIT_ROW;
const int CREDIT_Y = (SCREEN_HEIGHT-CREDIT_HEIGHT)>>1;

const int TITLE_ENG_X = (SCREEN_WIDTH-15*FONT_WIDTH)>>1;
const int ORIGINAL_X = (SCREEN_WIDTH-33*SMALL_FONT_WIDTH)>>1;					
const int PROGRAMMING_X = (SCREEN_WIDTH-13*FONT_WIDTH)>>1;
const int PROGRAMMER_X = (SCREEN_WIDTH-12*FONT_WIDTH)>>1;
const int GAMEDESIGN_X = (SCREEN_WIDTH-13*FONT_WIDTH)>>1;
const int GAMEDESIGNER_X = (SCREEN_WIDTH-12*FONT_WIDTH)>>1;
const int GAMETESTING_X = (SCREEN_WIDTH-14*FONT_WIDTH)>>1;
const int GAMETESTER_X = (SCREEN_WIDTH-13*FONT_WIDTH)>>1;
const int THANKSTO_X = (SCREEN_WIDTH-18*FONT_WIDTH)>>1;
const int SPECIALIST_X = (SCREEN_WIDTH-13*FONT_WIDTH)>>1;
const int THANKSFOR_X = (SCREEN_WIDTH-21*SMALL_FONT_WIDTH)>>1;
const int HAVEFUN_X = (SCREEN_WIDTH-14*SMALL_FONT_WIDTH)>>1;


static BOOL creditExit;
static int creditY;
static int titleY, originalY;
static int programmingY, programmerY;
static int gamedesignY, gamedesignerY;
static int gametestingY, gametesterY;
static int specialthankstoY, specialistY;
static int thanksforY, havefunY;


int GameCredit()
{
	init();

	creditExit = FALSE;
	while(!creditExit){
		startClock();
		Message_Pump();
		dinput->update();
		if(g_key) creditExit = TRUE;
		if(mouse->isClicked()) creditExit = TRUE;

		control();
		draw();

		waitClock(30);
		ddraw->flip();
	}

	shutdown();
	return GAME_MENU;
}


void init()
{
	title->setPos(TITLE_X, TITLE_Y);
	creditY = CREDIT_Y+CREDIT_HEIGHT;
	programmingY = programmerY = 0;
	gamedesignY = gamedesignerY = 0;
	gametestingY = gametesterY = 0;
	specialthankstoY = specialistY = 0;
	playSound(SOUND_BGM);
}


void shutdown()
{
	setClipRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	stopSound(SOUND_BGM);
}


void control()
{
	--creditY;

	titleY = creditY + 16;
	originalY = titleY + FONT_HEIGHT + 32;
	programmingY = originalY + SMALL_FONT_HEIGHT + 64;
	programmerY = programmingY + FONT_HEIGHT + 32;
	gamedesignY = programmerY + FONT_HEIGHT + 64;
	gamedesignerY = gamedesignY + FONT_HEIGHT + 32;
	gametestingY = gamedesignerY + FONT_HEIGHT + 64;
	gametesterY = gametestingY + FONT_HEIGHT + 32;
	specialthankstoY = gametesterY + FONT_HEIGHT + 64;
	specialistY = specialthankstoY + FONT_HEIGHT + 32;
	thanksforY = specialistY + FONT_HEIGHT + 64;
	havefunY = thanksforY + FONT_HEIGHT;

	if(havefunY+FONT_WIDTH < CREDIT_Y) creditY = CREDIT_Y+CREDIT_HEIGHT;
	moveParticle();
	if(mouse->isMoving()){
		startBigBang(mouse->x, mouse->y, 1, 2, 8);
		startBigBang(mouse->x, mouse->y, 1, 6, 12);
	}
}


void draw()
{
	ddraw->clearBackSurface();

	title->renderFrameFast();

	setClipRect(0, CREDIT_Y, SCREEN_WIDTH, CREDIT_Y+CREDIT_HEIGHT);
	font->drawStringClip("PACMAN returns!", TITLE_ENG_X, titleY);
	font16->drawStringClip("based on the original PACMAN game", ORIGINAL_X, originalY);
	font->drawStringClip("<Programming>", PROGRAMMING_X, programmingY);
	font->drawStringClip("Lee Soon Gyu", PROGRAMMER_X, programmerY);
	font->drawStringClip("<Game Design>", GAMEDESIGN_X, gamedesignY);
	font->drawStringClip("Lee Soon Gyu", GAMEDESIGNER_X, gamedesignerY);
	font->drawStringClip("<Game Testing>", GAMETESTING_X, gametestingY);
	font->drawStringClip("Lee Chang Gyu", GAMETESTER_X, gametesterY);
	font->drawStringClip("Special Thanks to:", THANKSTO_X, specialthankstoY);
	font->drawStringClip("Lee Chang Gyu", SPECIALIST_X, specialistY);
	font16->drawStringClip("Thanks for playing...", THANKSFOR_X, thanksforY);
	font16->drawStringClip("Have Fun!! ^^;", HAVEFUN_X, havefunY);

	setClipRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	drawParticle();
	mouse->draw();
}
