/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "dx\includeDX.h"
#include "gui\GUI.h"
#include "GameEdit.h"
#include "pacman.h"
#include "sound.h"
#include "font.h"
#include "mouse.h"
#include "map.h"
#include "particle.h"
#include "unit_pacman.h"
#include "unit_ghost.h"
#include "unit_portal.h"


// ܺ  
extern DDraw *ddraw;
extern DInput *dinput;
extern BMP *bmp;
extern WORD g_key;
extern Font *font;
extern Font *font16;
extern Mouse *mouse;
extern Map *map;
extern Pacman *pacman;
extern Ghost *ghost[MAX_GHOST];
extern Portal *portal1;
extern Portal *portal2;
extern Portal *portalGhost;
extern Sprite *title;
extern Sprite *smiley;
extern Sprite *tileBlack;


// editMode
#define EDIT_MODE_EDITING	0
#define EDIT_MODE_SAVING	1
#define EDIT_MODE_LOADING	2
#define EDIT_MODE_QUIT		3

// selectedUnit
#define TILE	0
#define EGG		1
#define PACMAN	2
#define GHOST	3
#define PORTAL1	4
#define PORTAL2 5
#define POWERUP	6

#define MAX_COUNT_SAVE	50

#define UPDOWN_LOAD_X	323
#define UPDOWN_LOAD_Y	149
#define RADIO_LOAD_X	323
#define RADIO_LOAD_Y	166

// 
const int TITLE_X = (STAGE_WIDTH-TITLE_WIDTH)>>1;
const int TITLE_Y = 0;

const int STAGE_LABEL_X = STAGE_WIDTH+4;
const int STAGE_LABEL_Y = FONT_HEIGHT;
const int STAGE_NUM_X = STAGE_WIDTH+4;
const int STAGE_NUM_Y = STAGE_LABEL_Y+16;
const int STAGE_BUTTON_X = STAGE_NUM_X+FONT_WIDTH*3;
const int STAGE_BUTTON_Y = STAGE_NUM_Y;
const int TILESET_LABEL_X = STAGE_WIDTH+4;
const int TILESET_LABEL_Y = STAGE_NUM_Y+FONT_HEIGHT+16;
const int TILESET_X = STAGE_WIDTH+4;
const int TILESET_Y = TILESET_LABEL_Y+16;
const int TILESET_BUTTON_X = TILESET_X+FONT_WIDTH*3;
const int TILESET_BUTTON_Y = TILESET_Y;
const int SELECTED_UNIT_X = STAGE_WIDTH+4;
const int SELECTED_UNIT_Y = TILESET_Y+36;
const int TILE_BUTTON_X = STAGE_WIDTH+4;
const int TILE_BUTTON_Y = SELECTED_UNIT_Y+UNIT_WIDTH+16;
const int EGG_BUTTON_Y = TILE_BUTTON_Y+24;
const int POWERUP_BUTTON_Y = EGG_BUTTON_Y+24;
const int PACMAN_BUTTON_Y = POWERUP_BUTTON_Y+24;
const int GHOST_BUTTON_Y = PACMAN_BUTTON_Y+24;
const int PORTAL1_BUTTON_Y = GHOST_BUTTON_Y+24;
const int PORTAL2_BUTTON_Y = PORTAL1_BUTTON_Y+24;

const int SAVE_BUTTON_X = STAGE_WIDTH+4;
const int SAVE_BUTTON_Y = SCREEN_HEIGHT-96;
const int LOAD_BUTTON_X = SAVE_BUTTON_X;
const int LOAD_BUTTON_Y = SCREEN_HEIGHT-64;
const int QUIT_BUTTON_X = SAVE_BUTTON_X;
const int QUIT_BUTTON_Y = SCREEN_HEIGHT-32;

const int MSG_BUTTON_X = (STAGE_WIDTH-16*8)>>1;
const int MSG_BUTTON_Y = ((STAGE_HEIGHT-16)>>1) + STAGE_Y;
const int ASK_BUTTON_X = (STAGE_WIDTH-16*13)>>1;
const int ASK_BUTTON_Y = MIDDLE_STAGE_HEIGHT - TILE_HEIGHT;
const int YES_BUTTON_X = MIDDLE_STAGE_WIDTH - 16*5 - TILE_WIDTH;
const int YES_BUTTON_Y = MIDDLE_STAGE_HEIGHT;
const int NO_BUTTON_X = MIDDLE_STAGE_WIDTH + TILE_WIDTH;
const int NO_BUTTON_Y = YES_BUTTON_Y;

// ƽ 
static Button *stageButtonUp, *stageButtonDown, *tilesetButtonUp, *tilesetButtonDown;
static RadioButton *tileButton, *eggButton;
static RadioButton *pacmanButton, *ghostButton;
static RadioButton *portal1Button, *portal2Button;
static RadioButton *powerupButton;
static Button *saveButton, *loadButton, *quitButton;
static Button *msgButton, *askButton, *yesButton, *noButton;
static Sprite *tile[MAX_TILE];
static Sprite *radio;
static Sprite *tileSprite;

static BOOL editExit;
static int editMode;
static int selectedUnit, isChanged;
static int currStage, currTileSet;
static int index, row, col, val;


int GameEdit()
{
	init();

	editExit = FALSE;
	while(!editExit){
		startClock();
		Message_Pump();
		dinput->update();
		if(dinput->keyDown(DIK_F10)){
			editExit = TRUE;
			g_key = VK_F10;
		}
		if(dinput->keyDown(DIK_RIGHTARROW)) pacman->setDir(DIR_RIGHT);
		if(dinput->keyDown(DIK_UPARROW)){
			pacman->setDir(DIR_UP);
		}
		if(dinput->keyDown(DIK_LEFTARROW)) pacman->setDir(DIR_LEFT);
		if(dinput->keyDown(DIK_DOWNARROW)){
			pacman->setDir(DIR_DOWN);
		}

		moveParticle();
		switch(editMode){
		case EDIT_MODE_EDITING:
			if(g_key==VK_ESCAPE){
				editMode = EDIT_MODE_QUIT;
			}
			if(mouse->isDragged()){
				update();
			}
			if(mouse->isDraggedRB()) deleteTile();
			control();
			break;
		case EDIT_MODE_SAVING:
			save();
			break;
		case EDIT_MODE_LOADING:
			load();
			break;
		case EDIT_MODE_QUIT:
			quit();
			break;
		}
		draw();

		waitClock(30);
		ddraw->flip();
	}

	shutdown();
	if(g_key==VK_F10) return GAME_EXIT;
	return GAME_MENU;
}


void init()
{
	tileSprite = new Sprite(TILE_WIDTH, TILE_HEIGHT);
	radio = new Sprite(16,16);
	stageButtonUp = new Button(16,16);
	stageButtonDown = new Button(16,16);
	tilesetButtonUp = new Button;
	tilesetButtonDown = new Button;
	tileButton = new RadioButton("Tile");
	eggButton = new RadioButton("Egg:");
	powerupButton = new RadioButton("Power:");
	pacmanButton = new RadioButton("Pacman");
	ghostButton = new RadioButton("Ghost");
	portal1Button = new RadioButton("Portal1");
	portal2Button = new RadioButton("Portal2");
	saveButton = new Button("Save");
	loadButton = new Button("Load");
	msgButton = new Button();
	quitButton = new Button("Quit");
	askButton = new Button("Are you sure?");
	yesButton = new Button("[Y]es");
	noButton = new Button("[N]o");

	stageButtonUp->setPos(STAGE_BUTTON_X, STAGE_BUTTON_Y);
	stageButtonDown->setPos(STAGE_BUTTON_X, STAGE_BUTTON_Y+16);
	tilesetButtonUp->setPos(TILESET_BUTTON_X, TILESET_BUTTON_Y);
	tilesetButtonDown->setPos(TILESET_BUTTON_X, TILESET_BUTTON_Y+16);
	tileButton->setPos(TILE_BUTTON_X, TILE_BUTTON_Y);
	eggButton->setPos(TILE_BUTTON_X, EGG_BUTTON_Y);
	powerupButton->setPos(TILE_BUTTON_X, POWERUP_BUTTON_Y);
	pacmanButton->setPos(TILE_BUTTON_X, PACMAN_BUTTON_Y);
	ghostButton->setPos(TILE_BUTTON_X, GHOST_BUTTON_Y);
	portal1Button->setPos(TILE_BUTTON_X, PORTAL1_BUTTON_Y);
	portal2Button->setPos(TILE_BUTTON_X, PORTAL2_BUTTON_Y);

	saveButton->setPos(SAVE_BUTTON_X, SAVE_BUTTON_Y);
	loadButton->setPos(LOAD_BUTTON_X, LOAD_BUTTON_Y);
	quitButton->setPos(QUIT_BUTTON_X, QUIT_BUTTON_Y);
	msgButton->setPos(MSG_BUTTON_X, MSG_BUTTON_Y);
	askButton->setPos(ASK_BUTTON_X, ASK_BUTTON_Y);
	yesButton->setPos(YES_BUTTON_X, YES_BUTTON_Y);
	noButton->setPos(NO_BUTTON_X, NO_BUTTON_Y);

	bmp->load("font.bmp");
	Sprite::setLoadPos(UPDOWN_LOAD_X, UPDOWN_LOAD_Y);
	stageButtonUp->loadFrame(bmp, 0, 0, 0);
	stageButtonDown->loadFrame(bmp, 0, 1, 0);
	Sprite::setLoadPos(RADIO_LOAD_X, RADIO_LOAD_Y);
	radio->loadFrame(bmp, 0, 0, 0);
	radio->loadFrame(bmp, 1, 1, 0);
	bmp->release();

	tilesetButtonUp->getFrames(stageButtonUp);
	tilesetButtonDown->getFrames(stageButtonDown);
	tileButton->getFrames(radio);
	eggButton->getFrames(radio);
	powerupButton->getFrames(radio);
	pacmanButton->getFrames(radio);
	ghostButton->getFrames(radio);
	portal1Button->getFrames(radio);
	portal2Button->getFrames(radio);
	tileSprite->getFrames(map->tile[0]);

	for(index=0; index < MAX_TILE; index++){
		tile[index] = new Sprite(TILE_WIDTH, TILE_HEIGHT);
		tile[index]->getFrames(map->getTileSprite(index));
	}

	title->setPos(TITLE_X, TITLE_Y);
	tileSprite->setPos(SELECTED_UNIT_X, SELECTED_UNIT_Y);
	smiley->setPos(SELECTED_UNIT_X, SELECTED_UNIT_Y);
	portalGhost->setPos(SELECTED_UNIT_X, SELECTED_UNIT_Y);
	tileButton->isSelected = TRUE;
	selectedUnit = TILE;
	isChanged = FALSE;
	currStage = 0;
	initStage();
	editMode = EDIT_MODE_LOADING;
	playSound(SOUND_PACMAN);
}


void shutdown()
{
	delete tileSprite;
	delete radio;
	delete stageButtonUp;
	delete stageButtonDown;
	delete tilesetButtonUp;
	delete tilesetButtonDown;
	delete tileButton;
	delete eggButton;
	delete powerupButton;
	delete pacmanButton;
	delete ghostButton;
	delete portal1Button;
	delete portal2Button;
	delete saveButton;
	delete loadButton;
	delete quitButton;
	delete msgButton;
	delete askButton;
	delete yesButton;
	delete noButton;
	for(index=0; index < MAX_TILE; index++){
		if(tile[index]) delete tile[index];
	}
}


void update()
{
	static int tempX, tempY;
	tempX = mouse->x + INTERVAL_WIDTH;
	tempY = mouse->y + INTERVAL_HEIGHT - STAGE_Y;

	row = tempY/TILE_HEIGHT;
	col = tempX/TILE_WIDTH;
	val = map->getTile(row, col);

	if(mouse->testCollision(pacman)) return;
	if(mouse->testCollision(ghost[0])) return;
	if(mouse->testCollision(portal1)) return;
	if(mouse->testCollision(portal2)) return;

	if((row>0 && row<STAGE_ROWS-1) && (col>0 && col<STAGE_COLS-1) && (!val)){
		playSound(SOUND_EATDOT);
		startBigBang(mouse->x, mouse->y, 6, 2, 8, rand()%4);
		startBigBang(mouse->x, mouse->y, 6, 4, 10, rand()%4);
		switch(selectedUnit){
		case TILE:
			map->setTile(row,col,1);
			map->convertTile(row, col);
			map->convertTile(row, col+1);
			map->convertTile(row+1, col);
			map->convertTile(row, col-1);
			map->convertTile(row-1, col);
			isChanged = TRUE;
			break;
		case EGG:
			if(++map->stage[currStage].numEgg > MAX_EGG) map->stage[currStage].numEgg = MAX_EGG;
			else{
				map->setTile(row, col, -2);
				isChanged = TRUE;
			}
			break;
		case POWERUP:
			if(++map->stage[currStage].numPowerup > MAX_POWERUP) map->stage[currStage].numPowerup = MAX_POWERUP;
			else{
				map->setTile(row, col, -1);
				isChanged = TRUE;
			}
			break;
		case PACMAN:
			map->stage[currStage].pacmanRow = row;
			map->stage[currStage].pacmanCol = col;
			pacman->setRC(row, col);
			pacman->setState(1);
			isChanged = TRUE;
			break;
		case GHOST:
			map->stage[currStage].ghostRow = row;
			map->stage[currStage].ghostCol = col;
			ghost[0]->setRC(row, col);
			ghost[0]->setState(1);
			isChanged = TRUE;
			break;
		case PORTAL1:
			map->stage[currStage].portal1Row = row;
			map->stage[currStage].portal1Col = col;
			portal1->setRC(row, col);
			portal1->setState(1);
			isChanged = TRUE;
			break;
		case PORTAL2:
			map->stage[currStage].portal2Row = row;
			map->stage[currStage].portal2Col = col;
			portal2->setRC(row, col);
			portal2->setState(1);
			isChanged = TRUE;
			break;
		}
	}
}


void deleteTile()
{
	static int tempX, tempY;
	tempX = dinput->mouseX + INTERVAL_WIDTH;
	tempY = dinput->mouseY + INTERVAL_HEIGHT - STAGE_Y;

	row = tempY/TILE_HEIGHT;
	col = tempX/TILE_WIDTH;
	if((row>0 && row<STAGE_ROWS-1) && (col>0 && col<STAGE_COLS-1)){
		val = map->getTile(row, col);
		if(val){
			playSound(SOUND_PONG);
			if(val==-1){
				if(--map->stage[currStage].numPowerup < 0) map->stage[currStage].numPowerup = 0;
			}
			else if(val==-2){
				if(--map->stage[currStage].numEgg < 0) map->stage[currStage].numEgg = 0;
			}
			map->setTile(row, col, 0);
			map->convertTile(row, col);
			map->convertTile(row, col+1);
			map->convertTile(row+1, col);
			map->convertTile(row, col-1);
			map->convertTile(row-1, col);
		}
	}
}


void draw()
{
	ddraw->clearBackSurface();
	title->renderFrameFast();
	font16->drawStringFast("Stage:", STAGE_LABEL_X, STAGE_LABEL_Y);
	font->drawStringFast(toString(currStage+1, 3), STAGE_NUM_X, STAGE_NUM_Y);
	font16->drawStringFast("TileSet:", TILESET_LABEL_X, TILESET_LABEL_Y);
	font->drawStringFast(toString(currTileSet+1, 3), TILESET_X, TILESET_Y);
	font16->drawStringFast(toString(map->stage[currStage].numEgg, 3), TILE_BUTTON_X+80, EGG_BUTTON_Y);
	font16->drawStringFast(toString(map->stage[currStage].numPowerup, 2), TILE_BUTTON_X+96, POWERUP_BUTTON_Y);
	stageButtonUp->draw();
	stageButtonDown->draw();
	tilesetButtonUp->draw();
	tilesetButtonDown->draw();
	tileButton->draw();
	eggButton->draw();
	powerupButton->draw();
	pacmanButton->draw();
	ghostButton->draw();
	portal1Button->draw();
	portal2Button->draw();
	saveButton->draw();
	loadButton->draw();
	quitButton->draw();

	map->drawStage();
	if(portal1->state) portal1->renderFrame();
	if(portal2->state) portal2->renderFrame();
	if(pacman->state) pacman->draw();
	if(ghost[0]->state) ghost[0]->draw();

	switch(selectedUnit){
	case TILE:
		tileSprite->renderFrameFast(2);
		break;
	case EGG:
		tileSprite->renderFrameFast(0);
		break;
	case POWERUP:
		tileSprite->renderFrameFast(1);
		break;
	case PACMAN:
		smiley->renderFrameFast();
		break;
	case GHOST:
		portalGhost->renderFrameFast(0);
		break;
	case PORTAL1:
		portal1->backupPos();
		portal1->setPos(SELECTED_UNIT_X, SELECTED_UNIT_Y);
		portal1->renderFrameFast(0);
		portal1->restorePos();
		break;
	case PORTAL2:
		portal2->backupPos();
		portal2->setPos(SELECTED_UNIT_X, SELECTED_UNIT_Y);
		portal2->renderFrameFast(0);
		portal2->restorePos();
		break;
	}

	switch(editMode){
	case EDIT_MODE_SAVING:
	case EDIT_MODE_LOADING:
		drawBox(2, 8*16/24+1);
		msgButton->draw();
		break;
	case EDIT_MODE_QUIT:
		drawBox(3, 13*16/24+1);
		askButton->draw();
		yesButton->draw();
		noButton->draw();
		break;
	}
	drawParticle();
	mouse->draw();
}


void control()
{
	if(stageButtonUp->isClicked()){
		if(++currStage>=MAX_STAGE) --currStage;
		else initStage();
	}
	if(stageButtonDown->isClicked()){
		if(--currStage<0) ++currStage;
		else initStage();
	}
	if(tilesetButtonUp->isClicked()){
		if(++currTileSet>=MAX_TILE) --currTileSet;
		else map->stage[currStage].tileSet = map->currTileSet = currTileSet;
	}
	if(tilesetButtonDown->isClicked()){
		if(--currTileSet<0) ++currTileSet;
		else map->stage[currStage].tileSet = map->currTileSet = currTileSet;
	}
	if(tileButton->isClicked()){
		selectedUnit = TILE;
		tileButton->isSelected = TRUE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = FALSE;
	}
	else if(eggButton->isClicked()){
		selectedUnit = EGG;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = TRUE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = FALSE;
	}
	else if(pacmanButton->isClicked()){
		selectedUnit = PACMAN;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = TRUE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = FALSE;
	}
	else if(ghostButton->isClicked()){
		selectedUnit = GHOST;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = TRUE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = FALSE;
	}
	else if(portal1Button->isClicked()){
		selectedUnit = PORTAL1;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = TRUE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = FALSE;
	}
	else if(portal2Button->isClicked()){
		selectedUnit = PORTAL2;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = TRUE;
		powerupButton->isSelected = FALSE;
	}
	else if(powerupButton->isClicked()){
		selectedUnit = POWERUP;
		tileButton->isSelected = FALSE;
		eggButton->isSelected = FALSE;
		pacmanButton->isSelected = FALSE;
		ghostButton->isSelected = FALSE;
		portal1Button->isSelected = FALSE;
		portal2Button->isSelected = FALSE;
		powerupButton->isSelected = TRUE;
	}
	if(g_key==0x53 || saveButton->isClicked()){
		editMode = EDIT_MODE_SAVING;
	}
	if(g_key==0x4c || loadButton->isClicked()){
		editMode = EDIT_MODE_LOADING;
	}
	if(g_key==0x51 || quitButton->isClicked()){
		editMode = EDIT_MODE_QUIT;
	}
}


void initStage()
{
	map->setCurrStage(currStage);
	map->initStage();

	row = map->stage[currStage].pacmanRow;
	col = map->stage[currStage].pacmanCol;
	pacman->setRC(row, col);
	if(!row || !col) pacman->setState(0);
	else pacman->setState(1);

	row = map->stage[currStage].ghostRow;
	col = map->stage[currStage].ghostCol;
	ghost[0]->setRC(row, col);
	if(!row || !col) ghost[0]->setState(0);
	else ghost[0]->setState(1);

	row = map->stage[currStage].portal1Row;
	col = map->stage[currStage].portal1Col;
	portal1->setRC(row, col);
	if(!row || !col) portal1->setState(0);
	else portal1->setState(1);

	row = map->stage[currStage].portal2Row;
	col = map->stage[currStage].portal2Col;
	portal2->setRC(row, col);
	if(!row || !col) portal2->setState(0);
	else portal2->setState(1);

	currTileSet = map->currTileSet;
}


void save()
{
	static int step = 0, count = 0;
	switch(step){
	case 0:
		if(map->save("pacman.map")){
			msgButton->setLabel("Saved...");
		}
		else{
			msgButton->setLabel("Failed..");
		}
		playSound(SOUND_TRANSMISSION);
		mouse->setPos(MIDDLE_STAGE_WIDTH, MIDDLE_STAGE_HEIGHT);
		step = 1;
		break;
	case 1:
		if(++count > MAX_COUNT_SAVE || msgButton->isClicked()) step = 2;
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
			step = 2;
			break;
		}
		break;
	case 2:
		msgButton->setLabel("........");
		initStage();
		isChanged = FALSE;
		editMode = EDIT_MODE_EDITING;
		step = 0;
		count = 0;
		break;
	}
}


void load()
{
	static int step = 0, count = 0;
	switch(step){
	case 0:
		if(map->load("pacman.map")){
			msgButton->setLabel("Loaded..");
		}
		else{
			msgButton->setLabel("Failed..");
		}
		playSound(SOUND_TRANSMISSION);
		mouse->setPos(MIDDLE_STAGE_WIDTH, MIDDLE_STAGE_HEIGHT);
		step = 1;
		break;
	case 1:
		if(++count > MAX_COUNT_SAVE || msgButton->isClicked()) step = 2;
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
			step = 2;
			break;
		}
		break;
	case 2:
		msgButton->setLabel("........");
		initStage();
		isChanged = FALSE;
		editMode = EDIT_MODE_EDITING;
		step = 0;
		count = 0;
		break;
	}
}


void quit()
{
	static int step = 0;
	switch(step){
	case 0:
		playSound(SOUND_TRANSMISSION);
		mouse->setPos(MIDDLE_STAGE_WIDTH, MIDDLE_STAGE_HEIGHT);
		step = 1;
		break;
	case 1:
		if(yesButton->isClicked() || g_key==VK_RETURN || g_key==0x59){
			editMode = EDIT_MODE_EDITING;
			editExit = TRUE;
			step = 0;
		}
		else if(noButton->isClicked() || g_key==VK_ESCAPE || g_key==0x4E){
			editMode = EDIT_MODE_EDITING;
			step = 0;
		}
		break;
	}
}


void drawBox(int r, int c)
{
	static int x, y;
	const int tileSet = MAX_TILE - 2;

	++r;
	++c;
	x = (STAGE_WIDTH - (c+1)*TILE_WIDTH)/2;
	y = (STAGE_HEIGHT - (r+1)*TILE_HEIGHT)/2 + STAGE_Y;

	tile[tileSet]->setPos(x, y);
	tile[tileSet]->renderFrame((TILE_RIGHT|TILE_DOWN)+2);
	tile[tileSet]->setPos(x+c*TILE_WIDTH, y);
	tile[tileSet]->renderFrame((TILE_LEFT|TILE_DOWN)+2);
	tile[tileSet]->setPos(x, y+r*TILE_HEIGHT);
	tile[tileSet]->renderFrame((TILE_RIGHT|TILE_UP)+2);
	tile[tileSet]->setPos(x+c*TILE_WIDTH, y+r*TILE_HEIGHT);
	tile[tileSet]->renderFrame((TILE_LEFT|TILE_UP)+2);

	val = (TILE_LEFT|TILE_RIGHT)+2;
	for(col=1; col < c; col++){
		tile[tileSet]->setPos(x+col*TILE_WIDTH, y);
		tile[tileSet]->renderFrame(val);
		tile[tileSet]->setPos(x+col*TILE_WIDTH, y+r*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
	}

	val = (TILE_UP|TILE_DOWN)+2;
	for(row=1; row < r; row++){
		tile[tileSet]->setPos(x, y+row*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
		tile[tileSet]->setPos(x+c*TILE_WIDTH, y+row*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
	}
	for(row=1; row < r; row++){
		for(col=1; col < c; col++){
			tileBlack->setPos(x+col*TILE_WIDTH, y+row*TILE_HEIGHT);
			tileBlack->renderFrameFast();
		}
	}
}
