/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "dx\includeDX.h"
#include "gui\GUI.h"
#include "GameMenu.h"
#include "pacman.h"
#include "sound.h"
#include "midi.h"
#include "font.h"
#include "mouse.h"
#include "map.h"
#include "particle.h"
#include "unit_pacman.h"
#include "unit_ghost.h"
#include "unit_portal.h"


// ܺ  
extern DDraw *ddraw;
extern DInput *dinput;
extern BMP *bmp;
extern WORD g_key;
extern Font *font;
extern Font *font16;
extern Mouse *mouse;
extern Map *map;
extern Pacman *pacman;
extern Ghost *ghost[MAX_GHOST];
extern Ghost *ghost_weak;
extern Sprite *title;


#define MENU_ROW	9
#define MENU_COL	14

// 
const int TITLE_X = (SCREEN_WIDTH - TITLE_WIDTH)>>1;
const int TITLE_Y = 0;
const int MENU_X = (640-TILE_WIDTH*MENU_COL)>>1;
const int MENU_Y = (480-TILE_HEIGHT*MENU_ROW)>>1;
const int TITLE_ENG_X = (640-FONT_WIDTH*15)>>1;
const int TITLE_ENG_Y = (MENU_Y-FONT_HEIGHT)>>1;

const int PLAY_BUTTON_X = MENU_X + 4*TILE_WIDTH;
const int PLAY_BUTTON_Y = MENU_Y + 1*TILE_HEIGHT + 4;
const int EDIT_BUTTON_Y = PLAY_BUTTON_Y + TILE_HEIGHT*2;
const int CREDIT_BUTTON_Y = EDIT_BUTTON_Y + TILE_HEIGHT*2;
const int EXIT_BUTTON_Y = CREDIT_BUTTON_Y + TILE_HEIGHT*2;

const int COPYRIGHT_X = (640-27*SMALL_FONT_WIDTH)>>1;
const int COPYRIGHT_Y = (480-32);

const int PACMAN_X = SCREEN_WIDTH + UNIT_WIDTH;
const int PACMAN_Y = COPYRIGHT_Y - UNIT_HEIGHT;

const int MIDDLE_SCREEN_WIDTH = SCREEN_WIDTH>>1;
const int MIDDLE_SCREEN_HEIGHT = SCREEN_HEIGHT>>1;

// ƽ 
static int row, col, val, index;
static int menuTile[MENU_ROW][MENU_COL];
static Sprite *tileSprite;
static Button *playButton, *editButton, *creditButton, *exitButton;
static int selectedMenuItem;
static BOOL menuExit;
static Pacman *pacman2;


int GameMenu()
{
	init();
	playMidi(MIDI_MENU);

	menuExit = FALSE;
	while(!menuExit){
		startClock();
		Message_Pump();
		dinput->update();
		if(dinput->keyDown(DIK_F10) || g_key==VK_ESCAPE){
			selectedMenuItem = GAME_EXIT;
			menuExit = TRUE;
		}
		if(g_key==VK_RETURN) menuExit = TRUE;
		if(g_key==VK_UP){
			playSound(SOUND_MENU);
			selectUp();
		}
		if(g_key==VK_DOWN){
			playSound(SOUND_MENU);
			selectDown();
		}

		move();
		control();
		draw();

		waitClock(30);
		ddraw->flip();
	}

	stopMidi(MIDI_MENU);
	playSound(SOUND_MENUCOMMAND);
	shutdown();
	return selectedMenuItem;
}


void init()
{
	setClipRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);

	playButton = new Button("Play!!");
	editButton = new Button("Edit Stages");
	creditButton = new Button("Show Credits");
	exitButton = new Button("Exit");
	pacman2 = new Pacman;

	playButton->setPos(PLAY_BUTTON_X, PLAY_BUTTON_Y);
	editButton->setPos(PLAY_BUTTON_X, EDIT_BUTTON_Y);
	creditButton->setPos(PLAY_BUTTON_X, CREDIT_BUTTON_Y);
	exitButton->setPos(PLAY_BUTTON_X, EXIT_BUTTON_Y);
	pacman2->x = MENU_X + COL_TO_X(2);
	pacman2->y = MENU_Y + ROW_TO_Y(1);
	pacman2->getFrames(pacman);
	pacman2->setDir(DIR_RIGHT);

	tileSprite = new Sprite(TILE_WIDTH, TILE_HEIGHT);
	tileSprite->getFrames(map->tile[0]);

	memset(menuTile, 0, sizeof(menuTile));
	for(row=0; row < MENU_ROW; row++){
		menuTile[row][0] = 1;
		menuTile[row][MENU_COL-1] = 1;
	}
	for(col=0; col < MENU_COL; col++){
		menuTile[0][col] = 1;
		menuTile[MENU_ROW-1][col] = 1;
	}
	for(row=1; row < MENU_ROW; row+=2){
		menuTile[row][3] = -1;
	}
	for(row=0; row < MENU_ROW; row++){
		for(col=0; col < MENU_COL; col++){
			val = 0;
			if(menuTile[row][col]>0){
				if(row>0 && menuTile[row-1][col]>0) val |= TILE_UP;
				if(row<MENU_ROW-1 && menuTile[row+1][col]>0) val |= TILE_DOWN;
				if(col>0 && menuTile[row][col-1]>0) val |= TILE_LEFT;
				if(col<MENU_COL-1 && menuTile[row][col+1]>0) val |= TILE_RIGHT;
				menuTile[row][col] = val+2;
			}
		}
	}
	selectedMenuItem = GAME_PLAY;

	title->setPos(TITLE_X, TITLE_Y);
	pacman->setPos(PACMAN_X, PACMAN_Y);
	pacman->setDir(DIR_LEFT);
	for(index=0; index < MAX_GHOST; index++){
		ghost[index]->setPos(PACMAN_X+UNIT_WIDTH*(index+2), PACMAN_Y);
		ghost[index]->setDir(DIR_LEFT);
	}
	ghost_weak->setPos(PACMAN_X+UNIT_WIDTH, PACMAN_Y);
	setClipRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	mouse->setPos(MIDDLE_SCREEN_WIDTH, MIDDLE_SCREEN_HEIGHT);
}


void shutdown()
{
	static int r, c;
	r = selectedMenuItem*2-1;
	while(TRUE){
		startClock();
		Message_Pump();
		c = (pacman2->x - MENU_X + INTERVAL_WIDTH)/TILE_WIDTH;
		if(menuTile[r][c] < 0) break;
		pacman2->x += 4;
		draw();
		waitClock(30);
		ddraw->flip();
	}

	delete playButton;
	delete editButton;
	delete creditButton;
	delete exitButton;
	delete pacman2;
	delete tileSprite;
}


void move()
{
	switch(pacman->dir){
	case DIR_LEFT:
		pacman->x -= UNIT_SPEED;
		for(index=0; index < MAX_GHOST; index++){
			ghost[index]->x -= UNIT_SPEED;
		}
		break;
	case DIR_RIGHT:
		pacman->x += UNIT_SPEED;
		for(index=0; index < MAX_GHOST; index++){
			ghost[index]->x += UNIT_SPEED;
		}
		break;
	}
	moveParticle();
}


void control()
{
	if(playButton->isClicked()){
		if(selectedMenuItem==GAME_PLAY) menuExit = TRUE;
		else selectedMenuItem = GAME_PLAY;
	}
	else if(editButton->isClicked()){
		if(selectedMenuItem==GAME_EDIT) menuExit = TRUE;
		else selectedMenuItem = GAME_EDIT;
	}
	else if(creditButton->isClicked()){
		if(selectedMenuItem==GAME_CREDIT) menuExit = TRUE;
		else selectedMenuItem = GAME_CREDIT;
	}
	else if(exitButton->isClicked()){
		if(selectedMenuItem==GAME_EXIT) menuExit = TRUE;
		else selectedMenuItem = GAME_EXIT;
	}

	switch(g_key){
	case 0x50:
		selectedMenuItem = GAME_PLAY;
		menuExit = TRUE;
		break;
	case 0x45:
		selectedMenuItem = GAME_EDIT;
		menuExit = TRUE;
		break;
	case 0x43:
		selectedMenuItem = GAME_CREDIT;
		menuExit = TRUE;
		break;
	case 0x58:
		selectedMenuItem = GAME_EXIT;
		menuExit = TRUE;
		break;
	}

	if(ghost[MAX_GHOST-1]->x + UNIT_WIDTH < 0) pacman->dir = DIR_RIGHT;
	else if(pacman->x > SCREEN_WIDTH) pacman->dir = DIR_LEFT;

	if(mouse->isMoving()) startBigBang(mouse->x, mouse->y, 1, 2, 8, rand()%4);
}


void draw()
{
	ddraw->clearBackSurface();
	title->renderFrameFast();
	font->drawStringFast("Pacman returns!", TITLE_ENG_X, TITLE_ENG_Y);
	drawMenu();
	switch(pacman->dir){
	case DIR_LEFT:
		pacman->setAni(DIR_LEFT);
		pacman->renderFrameClip();
		for(index=0; index < MAX_GHOST; index++){
			ghost[index]->setAni(DIR_LEFT);
			ghost[index]->renderFrameClip();
		}
		break;
	case DIR_RIGHT:
		pacman->setAni(DIR_RIGHT);
		pacman->renderFrameClip();
		ghost_weak->x = ghost[0]->x;
		ghost_weak->renderFrameClip();
		for(index=1; index < MAX_GHOST; index++){
			ghost_weak->x += UNIT_WIDTH;
			ghost_weak->renderFrameClip();
		}
		break;
	}

	drawParticle();
	font16->drawStringFast("Copyright 2002 Lee Soon Gyu", COPYRIGHT_X, COPYRIGHT_Y);
	mouse->draw();
}


void drawMenu()
{
	for(row=0; row < MENU_ROW; row++){
		for(col=0; col < MENU_COL; col++){
			val = menuTile[row][col];
			if(val>0){
				tileSprite->x = MENU_X + col*TILE_WIDTH;
				tileSprite->y = MENU_Y + row*TILE_HEIGHT;
				tileSprite->renderFrameFast(val);
			}
			else if(val==-1){
				tileSprite->x = MENU_X + col*TILE_WIDTH;
				tileSprite->y = MENU_Y + row*TILE_HEIGHT;
				tileSprite->renderFrameFast(1);
			}
			else if(val<-1){
				tileSprite->x = MENU_X + col*TILE_WIDTH;
				tileSprite->y = MENU_Y + row*TILE_HEIGHT;
				tileSprite->renderFrameFast(0);
			}
		}
	}

	playButton->draw();
	editButton->draw();
	creditButton->draw();
	exitButton->draw();

	pacman2->y = MENU_Y + ROW_TO_Y((selectedMenuItem<<1)-1);
	pacman2->draw();
}


void selectUp()
{
	if(--selectedMenuItem < GAME_PLAY) selectedMenuItem = GAME_EXIT;
}


void selectDown()
{
	if(++selectedMenuItem > GAME_EXIT) selectedMenuItem = GAME_PLAY;
}
