/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "dx\includeDX.h"
#include "gui\GUI.h"
#include "GamePlay.h"
#include "pacman.h"
#include "sound.h"
#include "midi.h"
#include "font.h"
#include "mouse.h"
#include "map.h"
#include "particle.h"
#include "unit_pacman.h"
#include "unit_ghost.h"
#include "unit_pikachu.h"
#include "unit_portal.h"


// ܺ  
extern DDraw *ddraw;
extern DInput *dinput;
extern BMP *bmp;
extern WORD g_key;
extern Font *font;
extern Font *font16;
extern Mouse *mouse;
extern Map *map;
extern Pacman *pacman;
extern Ghost *ghost[MAX_GHOST];
extern Pikachu *pikachu;
extern Portal *portal1;
extern Portal *portal2;
extern Portal *portalGhost;
extern Sprite *title;
extern Sprite *smiley;
extern Sprite *tileBlack;

// playMode
#define PLAY_MODE_READY			0
#define PLAY_MODE_PLAYING		1
#define PLAY_MODE_DYING			2
#define PLAY_MODE_DEAD			3
#define PLAY_MODE_STAGE_CLEAR	4
#define PLAY_MODE_GAME_OVER		5
#define PLAY_MODE_PAUSE			6
#define PLAY_MODE_QUIT			7

#define MAX_COUNT_READY			50
#define MAX_COUNT_DYING			50
#define MAX_COUNT_STAGE_CLEAR	40

#define MAX_COUNT_PIKACHU		222
#define MAX_COUNT_BONUS_SCORE	50

#define PIKACHU_BONUSSCORE		500


// 
const int TITLE_X = (STAGE_WIDTH-TITLE_WIDTH)>>1;
const int TITLE_Y = 0;
const int HIGH_SCORE_X = 4;
const int HIGH_SCORE_Y = 4;
const int SCORE_X = STAGE_WIDTH - 16*8 - 4;
const int SCORE_Y = HIGH_SCORE_Y;
const int STAGE_LABEL_X = STAGE_WIDTH + 4;
const int STAGE_LABEL_Y = 32;
const int SMILEY_X = STAGE_WIDTH+4;
const int SMILEY_Y = 64;
const int PIKACHU_X = STAGE_WIDTH+4;
const int PIKACHU_Y = 96;
const int PAUSE_BUTTON_X = STAGE_LABEL_X;
const int PAUSE_BUTTON_Y = SCREEN_HEIGHT-64;
const int QUIT_BUTTON_X = STAGE_LABEL_X;
const int QUIT_BUTTON_Y = SCREEN_HEIGHT-32;
const int RESUME_BUTTON_X = (STAGE_WIDTH-16*6)>>1;
const int RESUME_BUTTON_Y = ((STAGE_HEIGHT-16)>>1) + STAGE_Y;
const int ASK_BUTTON_X = (STAGE_WIDTH-16*13)>>1;
const int ASK_BUTTON_Y = MIDDLE_STAGE_HEIGHT - TILE_HEIGHT;
const int YES_BUTTON_X = MIDDLE_STAGE_WIDTH - 16*5 - TILE_WIDTH;
const int YES_BUTTON_Y = MIDDLE_STAGE_HEIGHT;
const int NO_BUTTON_X = MIDDLE_STAGE_WIDTH + TILE_WIDTH;
const int NO_BUTTON_Y = YES_BUTTON_Y;
const int BONUSSCORE_BUTTON_X = (STAGE_WIDTH-16*11)>>1;
const int BONUSSCORE_BUTTON_Y = MIDDLE_STAGE_HEIGHT - TILE_HEIGHT;
const int BONUSSCORE_BOARD_X = (STAGE_WIDTH-16*9)>>1;
const int BONUSSCORE_BOARD_Y = MIDDLE_STAGE_HEIGHT;

const int READY_BUTTON_X = (STAGE_WIDTH-16*6)>>1;
const int READY_BUTTON_Y = ((STAGE_HEIGHT-16)>>1) + STAGE_Y;
const int EXCELLENT_BUTTON_X = (STAGE_WIDTH-16*10)>>1;
const int EXCELLENT_BUTTON_Y = READY_BUTTON_Y;
const int GAMEOVER_BUTTON_X = (STAGE_WIDTH-16*9)>>1;
const int GAMEOVER_BUTTON_Y = READY_BUTTON_Y;

//  
Stage stage;
Label *bonusScoreLabel;
Button *bonusScoreButton, *excellentButton;
int gameCount;
int bonusScore, scoreCount;

// ƽ 
static BOOL playExit;
static int playMode;
static Button *readyButton, *gameoverButton;
static Button *pauseButton, *resumeButton, *quitButton;
static Button *askButton, *yesButton, *noButton;
static Sprite *tile[MAX_TILE];
static GameData gameData;
static int currStage, currTileSet;
static int bonusScoreCount;
static int index, row, col, val;


int GamePlay()
{
	static int count = 0;
	init();

	playExit = FALSE;
	while(!playExit){
		startClock();
		Message_Pump();
		dinput->update();
		if(dinput->keyDown(DIK_F10)){
			playExit = TRUE;
			g_key = VK_F10;
		}
		if(dinput->keyDown(DIK_RIGHTARROW)) pacman->setDir(DIR_RIGHT);
		if(dinput->keyDown(DIK_UPARROW)) pacman->setDir(DIR_UP);
		if(dinput->keyDown(DIK_LEFTARROW)) pacman->setDir(DIR_LEFT);
		if(dinput->keyDown(DIK_DOWNARROW)) pacman->setDir(DIR_DOWN);

		loopMidi(MIDI_PLAY);
		moveParticle();
		switch(playMode){
		case PLAY_MODE_READY:
			ready();
			draw();
			break;
		case PLAY_MODE_PLAYING:
			if(g_key==VK_ESCAPE){
				playMode = PLAY_MODE_PAUSE;
			}
			control();
			move();
			draw();
			break;
		case PLAY_MODE_DYING:
			dying();
			draw();
			break;
		case PLAY_MODE_DEAD:
			if(++count > MAX_COUNT_DYING){
				count = 0;
				if(--pacman->life > 0) playMode = PLAY_MODE_READY;
				else playMode = PLAY_MODE_GAME_OVER;
			}
			draw();
			drawParticle();
			break;
		case PLAY_MODE_STAGE_CLEAR:
			stageClear();
			draw();
			break;
		case PLAY_MODE_GAME_OVER:
			gameOver();
			draw();
			break;
		case PLAY_MODE_PAUSE:
			pause();
			draw();
			break;
		case PLAY_MODE_QUIT:
			quit();
			draw();
		}
		mouse->draw();
		waitClock(30);
		ddraw->flip();
	}

	shutdown();
	if(g_key==VK_F10) return GAME_EXIT;
	return GAME_MENU;
}


void init()
{
	setClipRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	bmp->release();
	pauseButton = new Button("Pause");
	resumeButton = new Button("Resume");
	quitButton = new Button("Quit");
	askButton = new Button("Are you sure?");
	yesButton = new Button("[Y]es");
	noButton = new Button("[N]o");

	pauseButton->setPos(PAUSE_BUTTON_X, PAUSE_BUTTON_Y);
	resumeButton->setPos(RESUME_BUTTON_X, RESUME_BUTTON_Y);
	quitButton->setPos(QUIT_BUTTON_X, QUIT_BUTTON_Y);
	askButton->setPos(ASK_BUTTON_X, ASK_BUTTON_Y);
	yesButton->setPos(YES_BUTTON_X, YES_BUTTON_Y);
	noButton->setPos(NO_BUTTON_X, NO_BUTTON_Y);

	bonusScoreLabel = new Label;
	readyButton = new Button("Ready!");
	gameoverButton = new Button("Game Over");
	excellentButton = new Button("Excellent!");
	bonusScoreButton = new Button("Bonus Score");
	readyButton->setPos(READY_BUTTON_X, READY_BUTTON_Y);
	gameoverButton->setPos(GAMEOVER_BUTTON_X, GAMEOVER_BUTTON_Y);
	excellentButton->setPos(EXCELLENT_BUTTON_X, EXCELLENT_BUTTON_Y);
	bonusScoreButton->setPos(BONUSSCORE_BUTTON_X, BONUSSCORE_BUTTON_Y);

	for(index=0; index < MAX_TILE; index++){
		tile[index] = new Sprite(TILE_WIDTH, TILE_HEIGHT);
		tile[index]->getFrames(map->getTileSprite(index));
	}

	map->load("pacman.map");

	title->setPos(TITLE_X, TITLE_Y);
	loadGameData();
	resetGame();
}


void resetGame()
{
	map->setCurrStage(0);
	map->initStage();
	memcpy(&stage, map->getStage(0), sizeof(Stage));
	currStage = 0;

	pacman->init();
	for(index=0; index < MAX_GHOST; index++) ghost[index]->init();
	pikachu->init();

	initGame();
	playMode = PLAY_MODE_READY;
}


void initGame()
{
	currTileSet = stage.tileSet;

	pacman->setRC(stage.pacmanRow, stage.pacmanCol);
	pacman->state = PACMAN_STATE_NORMAL;
	pacman->dir = pacman->old_dir = DIR_RIGHT;
	pacman->setAni(DIR_RIGHT);
	for(index=0; index<MAX_GHOST; index++){
		ghost[index]->setRC(stage.ghostRow, stage.ghostCol);
		ghost[index]->setState(GHOST_STATE_NORMAL);
	}
	pikachu->setState(PIKACHU_STATE_DEAD);
	portal1->setRC(stage.portal1Row, stage.portal1Col);
	portal2->setRC(stage.portal2Row, stage.portal2Col);
	portalGhost->setRC(stage.ghostRow, stage.ghostCol);

	Ghost::numCaughtGhosts = 0;
	gameCount = 0;
	bonusScore = 100;
	scoreCount = 0;

	bonusScoreLabel->setVisible(FALSE);
	excellentButton->setVisible(FALSE);
}


void shutdown()
{
	if(pauseButton) delete pauseButton;
	if(resumeButton) delete resumeButton;
	if(quitButton) delete quitButton;
	if(askButton) delete askButton;
	if(yesButton) delete yesButton;
	if(noButton) delete noButton;
	if(bonusScoreLabel) delete bonusScoreLabel;
	if(readyButton) delete readyButton;
	if(gameoverButton) delete gameoverButton;
	if(excellentButton) delete excellentButton;
	if(bonusScoreButton) delete bonusScoreButton;
	for(index=0; index < MAX_TILE; index++){
		if(tile[index]) delete tile[index];
	}
}


void control()
{
	static int excellentCount = 0;

	pacman->control();
	controlGhost();
	pikachu->control();

	if(++gameCount > MAX_COUNT_PIKACHU){
		gameCount = 0;
		if(rand()%100 < 40){
			while(1){
				row = rand()%STAGE_ROWS;
				col = rand()%STAGE_COLS;
				if(!stage.tile[row][col]) break;
			}
		}
		pikachu->start(row, col);
	}
	if(pacman->state==PACMAN_STATE_DYING){
		playMode = PLAY_MODE_DYING;
		pacman->state = PACMAN_STATE_NORMAL;
	}
	if(pacman->tempScore > 10000){
		++pacman->life;
		pacman->tempScore -= 10000;
		playSound(SOUND_BONUSLIFE);
	}
	if(pacman->life > MAX_LIFE) pacman->life = MAX_LIFE;
	if(stage.numEgg <= 0) playMode = PLAY_MODE_STAGE_CLEAR;

	if(bonusScoreLabel->isVisible){
		--bonusScoreLabel->y;
		if(++scoreCount > MAX_COUNT_BONUS_SCORE){
			bonusScoreLabel->setVisible(FALSE);
			scoreCount = 0;
		}
	}

	if(excellentButton->isVisible){
		if(++excellentCount > MAX_COUNT_READY || excellentButton->isClicked()){
			excellentButton->setVisible(FALSE);
			excellentCount = 0;
		}
	}
	if(g_key==0x50 || pauseButton->isClicked()){
		playMode = PLAY_MODE_PAUSE;
	}
	if(g_key==0x51 || quitButton->isClicked()){
		playMode = PLAY_MODE_QUIT;
	}
}


void move()
{
	pacman->move();
	moveGhost();
}


void draw()
{
	ddraw->clearBackSurface();
	title->renderFrameFast();
	drawStage();
	portal1->draw();
	portal2->draw();
	portalGhost->renderFrame();

	bonusScoreLabel->draw();
	pikachu->draw();
	pacman->draw();
	drawGhost();

	font16->drawStringFast("Stage", STAGE_LABEL_X, STAGE_LABEL_Y);
	font16->drawStringFast(toString(currStage+1,3), STAGE_LABEL_X+16*5, STAGE_LABEL_Y);
	font16->drawStringFast(toString(gameData.highScore,0), HIGH_SCORE_X, HIGH_SCORE_Y);
	font16->drawStringFast(toString(pacman->score,8), SCORE_X, SCORE_Y);

	for(index=0; index < pacman->life-1; index++){
		smiley->setPos(SMILEY_X + index*SMILEY_WIDTH, SMILEY_Y);
		smiley->renderFrameFast();
	}
	for(index=0; index < pikachu->numPikachu; index++){
		pikachu->backupPos();
		pikachu->setPos(PIKACHU_X + index*UNIT_WIDTH, PIKACHU_Y);
		pikachu->renderFrameFast(1);
		pikachu->restorePos();
	}
	pauseButton->draw();
	quitButton->draw();

	switch(playMode){
	case PLAY_MODE_READY:
		drawBox(2, 5);
		readyButton->draw();
		break;
	case PLAY_MODE_PLAYING:
		if(excellentButton->isVisible){
			drawBox(2, 10*16/24+1);
			excellentButton->draw();
		}
		break;
	case PLAY_MODE_STAGE_CLEAR:
		if(bonusScoreCount > 0){
			drawBox(3, 9);
			bonusScoreButton->draw();
			pikachu->backupPos();
			pikachu->setPos(BONUSSCORE_BOARD_X, BONUSSCORE_BOARD_Y-8);
			pikachu->renderFrame(1);
			pikachu->restorePos();
			font16->drawChar('x', BONUSSCORE_BOARD_X+16*2, BONUSSCORE_BOARD_Y);
			font16->drawString(toString(pikachu->numPikachu, 1), BONUSSCORE_BOARD_X+16*3, BONUSSCORE_BOARD_Y);
			font16->drawChar('=', BONUSSCORE_BOARD_X+16*4, BONUSSCORE_BOARD_Y);
			font16->drawString(toString(bonusScoreCount, 4), BONUSSCORE_BOARD_X+16*5, BONUSSCORE_BOARD_Y);
		}
		break;
	case PLAY_MODE_GAME_OVER:
		drawBox(2, 9*16/24+1);
		gameoverButton->draw();
		break;
	case PLAY_MODE_PAUSE:
		drawBox(2, 5);
		resumeButton->draw();
		break;
	case PLAY_MODE_QUIT:
		drawBox(3, 13*16/24+1);
		askButton->draw();
		yesButton->draw();
		noButton->draw();
		break;
	}
}


void drawStage()
{
	for(row=0; row < STAGE_ROWS; row++){
		for(col=0; col < STAGE_COLS; col++){
			val = stage.tile[row][col];
			if(val>0){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(val);
			}
			else if(val==-1){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(1);
			}
			else if(val==-2){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(0);
			}
		}
	}
}


void ready()
{
	static int step = 0, count = 0;

	switch(step){
	case 0:
		initGame();
		playSound(SOUND_TRANSMISSION);
		step = 1;
		break;
	case 1:
		if(++count > MAX_COUNT_READY || readyButton->isClicked()) step = 2;
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
			step = 2;
			break;
		}
		break;
	case 2:
		playMode = PLAY_MODE_PLAYING;
		step = 0;
		count = 0;
		break;
	}
}


void stageClear()
{
	static int step = 0, count = 0;
	static int totalBonusScore = 0;

	switch(step){
	case 0:
		playSound(SOUND_DINGDONG);
		totalBonusScore = pikachu->numPikachu*PIKACHU_BONUSSCORE;
		bonusScoreCount = 0;
		step = 1;
		count = 0;
		break;
	case 1:
		if(++count>MAX_COUNT_STAGE_CLEAR){
			step = 2;
			count = 0;
		}
		val = count%20;
		if(val>=0 && val<=9) currTileSet = ((map->currTileSet+1)>=MAX_TILE) ? 0 : map->currTileSet+1;
		else currTileSet = map->currTileSet;
		break;
	case 2:
		if(bonusScoreCount >= totalBonusScore || bonusScoreButton->isClicked()){
			pacman->score += totalBonusScore;
			pacman->tempScore += totalBonusScore;
			bonusScoreCount = totalBonusScore;
			playSound(SOUND_BONUSSCORE);
			step = 3;
		}
		else{
			bonusScoreCount += 10;
			playSound(SOUND_DING);
		}
		break;
	case 3:
		if(++count>MAX_COUNT_READY || bonusScoreButton->isClicked()){
			step = 4;
			count = 0;
		}
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
			step = 4;
			break;
		}
		break;
	case 4:
		if(++currStage >= MAX_STAGE) currStage = 0;
		map->setCurrStage(currStage);
		map->initStage();
		memcpy(&stage, &map->stage[currStage], sizeof(Stage));

		if(!isValidStage()){
			currStage = 0;
			map->setCurrStage(0);
			map->initStage();
			memcpy(&stage, map->getStage(0), sizeof(Stage));
		}
		currTileSet = map->currTileSet;

		pikachu->init();
		playMode = PLAY_MODE_READY;
		step = 0;
		count = 0;
		bonusScoreCount = 0;
		break;
	}
}


BOOL isValidStage()
{
	if(!stage.pacmanRow || !stage.pacmanCol) return FALSE;
	if(!stage.ghostRow || !stage.ghostCol) return FALSE;
	if(!stage.portal1Row || !stage.portal1Col) return FALSE;
	if(!stage.portal2Row || !stage.portal2Col) return FALSE;
	if(stage.numEgg<=0) return FALSE;
	
	return TRUE;
}


void dying()
{
	static int step = 0, count = 0;
	const int MAX_INTERVAL = 20;

	switch(step){
	case 0:
		if(++count > MAX_INTERVAL){
			pacman->state = PACMAN_STATE_DYING;
			playSound(SOUND_DYING);
			count = 0;
			step = 1;
		}
		break;
	case 1:
		if(pacman->state==PACMAN_STATE_DEAD) step = 2;
		break;
	case 2:
		startBigBang(pacman->x+16, pacman->y+16, MAX_PARTICLE, 17, 17);
		playMode = PLAY_MODE_DEAD;
		step = 0;
		count = 0;
		break;
	}
}


void gameOver()
{
	static int step = 0, count = 0;

	switch(step){
	case 0:
		playSound(SOUND_TRANSMISSION);
		step = 1;
		break;
	case 1:
		if(++count>MAX_COUNT_READY || gameoverButton->isClicked()) step = 2;
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
			step = 2;
			break;
		}
		break;
	case 2:
		if(pacman->score > gameData.highScore){
			gameData.highScore = pacman->score;
			saveGameData();
		}
		resetGame();
		step = 0;
		count = 0;
		break;
	}
}


void pause()
{
	static int step = 0;
	static int oldTileSet;

	switch(step){
	case 0:
		playSound(SOUND_TRANSMISSION);
		oldTileSet = currTileSet;
		currTileSet = MAX_TILE - 1;
		mouse->setPos(MIDDLE_STAGE_WIDTH, MIDDLE_STAGE_HEIGHT);
		step = 1;
		break;
	case 1:
		if(resumeButton->isClicked()) step = 2;
		switch(g_key){
		case VK_ESCAPE:
		case VK_RETURN:
		case VK_LEFT:
		case VK_UP:
		case VK_RIGHT:
		case VK_DOWN:
			step = 2;
			break;
		}
		break;
	case 2:
		currTileSet = oldTileSet;
		playMode = PLAY_MODE_PLAYING;
		step = 0;
		break;
	}
}


void quit()
{
	static int step = 0;
	static int oldTileSet;

	switch(step){
	case 0:
		playSound(SOUND_TRANSMISSION);
		oldTileSet = currTileSet;
		currTileSet = MAX_TILE - 1;
		mouse->setPos(MIDDLE_STAGE_WIDTH, MIDDLE_STAGE_HEIGHT);
		step = 1;
		break;
	case 1:
		if(noButton->isClicked() || g_key==VK_ESCAPE || g_key==0x4E){
			step = 2;
		}
		else if(yesButton->isClicked() || g_key==VK_RETURN || g_key==0x59){
			playSound(SOUND_GAMEEXIT);
			playExit = TRUE;
		}
		break;
	case 2:
		currTileSet = oldTileSet;
		playMode = PLAY_MODE_PLAYING;
		step = 0;
		break;
	}
}


void drawBox(int r, int c)
{
	static int x, y;
	const int tileSet = MAX_TILE - 2;

	++r;
	++c;
	x = (STAGE_WIDTH - (c+1)*TILE_WIDTH)/2;
	y = (STAGE_HEIGHT - (r+1)*TILE_HEIGHT)/2 + STAGE_Y;

	tile[tileSet]->setPos(x, y);
	tile[tileSet]->renderFrame((TILE_RIGHT|TILE_DOWN)+2);
	tile[tileSet]->setPos(x+c*TILE_WIDTH, y);
	tile[tileSet]->renderFrame((TILE_LEFT|TILE_DOWN)+2);
	tile[tileSet]->setPos(x, y+r*TILE_HEIGHT);
	tile[tileSet]->renderFrame((TILE_RIGHT|TILE_UP)+2);
	tile[tileSet]->setPos(x+c*TILE_WIDTH, y+r*TILE_HEIGHT);
	tile[tileSet]->renderFrame((TILE_LEFT|TILE_UP)+2);

	val = (TILE_LEFT|TILE_RIGHT)+2;
	for(col=1; col < c; col++){
		tile[tileSet]->setPos(x+col*TILE_WIDTH, y);
		tile[tileSet]->renderFrame(val);
		tile[tileSet]->setPos(x+col*TILE_WIDTH, y+r*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
	}

	val = (TILE_UP|TILE_DOWN)+2;
	for(row=1; row < r; row++){
		tile[tileSet]->setPos(x, y+row*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
		tile[tileSet]->setPos(x+c*TILE_WIDTH, y+row*TILE_HEIGHT);
		tile[tileSet]->renderFrame(val);
	}
	for(row=1; row < r; row++){
		for(col=1; col < c; col++){
			tileBlack->setPos(x+col*TILE_WIDTH, y+row*TILE_HEIGHT);
			tileBlack->renderFrameFast();
		}
	}
}


const char GameDataFile[] = "pacman.dat";
const char GameDataFileInfo[] = "PacMan GameData File";

BOOL saveGameData()
{
	FILE *fp;

	fp = fopen(GameDataFile, "wb");
	if(fp == NULL) return FALSE;

	fputs(GameDataFileInfo, fp);
	fwrite(&gameData, 1, sizeof(GameData), fp);
	fclose(fp);
	return TRUE;
}


BOOL loadGameData()
{
	FILE *fp;
	char buffer[30];

	fp = fopen(GameDataFile, "rb");
	if(fp == NULL) return FALSE;

	fgets(buffer, sizeof(GameDataFileInfo), fp);
	if(strcmp(buffer, GameDataFileInfo) != 0){
		memset(&gameData, 0, sizeof(GameData));
		return FALSE;
	}
	if(fread(&gameData, 1, sizeof(GameData), fp) != sizeof(GameData)){
		memset(&gameData, 0, sizeof(GameData));
		return FALSE;
	}
	fclose(fp);
	return TRUE;
}
