/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

/* Ģ */
// Ŭ, ü : Class ex) Sprite, Member, GameData, Game_data
// ޼ҵ, Լ : method, function ex) clearData, clear_data
//  : variable ex) name, memberName, member_name
// , ũ : CONSTANT, MACRO ex) TILE_NUM

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include "resource.h"

//#include "stdafx.h"
#include "dx\includeDX.h"
#include "gui\gui.h"
#include "pacman.h"
#include "font.h"
#include "mouse.h"
#include "map.h"
#include "sound.h"
#include "midi.h"
#include "particle.h"
#include "unit_pacman.h"
#include "unit_ghost.h"
#include "unit_pikachu.h"
#include "unit_portal.h"
#include "GameMenu.h"
#include "GamePlay.h"
#include "GameEdit.h"
#include "GameCredit.h"

#define FONT_LOAD_X			0
#define FONT_LOAD_Y			0
#define FONT16_LOAD_X		0
#define FONT16_LOAD_Y		132
#define MOUSE_LOAD_X		323
#define MOUSE_LOAD_Y		132
#define TITLE_LOAD_X		25
#define TITLE_LOAD_Y		0
#define PACMAN_LOAD_X		0
#define PACMAN_LOAD_Y		0
#define GHOST_LOAD_X		0
#define GHOST_LOAD_Y		264
#define PARTICLE_LOAD_X		0
#define PARTICLE_LOAD_Y		693
#define SMILEY_LOAD_X		297
#define SMILEY_LOAD_Y		0
#define PIKACHU_LOAD_X		330
#define PIKACHU_LOAD_Y		0


//  
WORD g_key;
DDraw *ddraw;
DInput *dinput;
BMP *bmp;
Font *font, *font16;
Mouse *mouse;
Map *map;
Pacman *pacman, *pacman_dead;
Pikachu *pikachu;
Portal *portal1, *portal2, *portalGhost;
Sprite *smiley;
Sprite *title;
Sprite *tileBlack;

// ƽ 
static MSG msg;
static HINSTANCE g_hinst;
static HWND g_hwnd;
static int gameMenu;

const char className[] = "PacMan";


/* Լ  */
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	WNDCLASSEX wc;
	HWND hWnd;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.lpszClassName = className;
	wc.lpfnWndProc = WindowProc;
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS | CS_OWNDC;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, MAKEINTRESOURCE(IDI_PACMAN));
	wc.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName = NULL;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;

	if(!RegisterClassEx(&wc)) return 0;

	hWnd = CreateWindowEx(NULL, className, className,
		WS_POPUP, 0, 0,
		GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
		NULL,  NULL, hInstance, NULL);
	if(hWnd==NULL) return 0;
	else{
		g_hinst = hInstance;
		g_hwnd = hWnd;
	}

	if(GameInit()==FALSE){
		MessageBox( hWnd, "DirectDraw init() failed.", "PacMan", MB_ICONERROR | MB_OK );
		return 0;
	}

	GameMain();
	/*
	while(TRUE){
		if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
			if(msg.message == WM_QUIT) break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		//Game_Main();
	}
	*/
	GameShutdown();

	return msg.wParam;
}


BOOL Message_Pump()
{
	g_key = 0;
	if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
		if(msg.message == WM_QUIT) return TRUE;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return FALSE;
}


HRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg){
		case WM_CREATE:
			break;
		case WM_KEYDOWN:
			switch((g_key=LOWORD(wParam))){
				case VK_RETURN:
					PostQuitMessage(0);
					break;
				case VK_ESCAPE:
					break;
			}
			return 0;
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
		default:
			break;
	}
	return DefWindowProc(hWnd, msg, wParam, lParam);
}


BOOL GameInit()
{
	ddraw = new DDraw(g_hwnd);
	dinput = new DInput;
	initSound(g_hwnd);
	initMidi(g_hwnd);
	bmp = new BMP;
	map = new Map;
	font = new Font;
	font16 = new Font(SMALL_FONT_WIDTH, SMALL_FONT_HEIGHT);
	mouse = new Mouse;
	pacman = new Pacman;
	pacman_dead = new Pacman;
	pikachu = new Pikachu;
	portal1 = new Portal;
	portal2 = new Portal;
	portalGhost = new Portal;
	smiley = new Sprite(SMILEY_WIDTH, SMILEY_HEIGHT);
	title = new Sprite(TITLE_WIDTH, TITLE_HEIGHT);
	tileBlack = new Sprite(TILE_WIDTH, TILE_HEIGHT);

	initGhost();
	initParticle();

	if(ddraw->initFullScreenMode(640, 480, 16)==FALSE) return FALSE;
	if(dinput->init(g_hinst, g_hwnd)==FALSE) return FALSE;

	loadSound();
	loadMidi();

	bmp->load("font.bmp");
	Sprite::setLoadPos(FONT_LOAD_X, FONT_LOAD_Y);
	font->loadFrames(bmp, 0, 0, 0, 13);
	font->loadFrames(bmp, 1, 0, 1, 18);
	font->loadFrames(bmp, 2, 0, 2, 17);
	font->loadFrames(bmp, 3, 0, 3, 15);
	Sprite::setLoadPos(FONT16_LOAD_X, FONT16_LOAD_Y);
	font16->loadFrames(bmp, 0, 0, 0, 13);
	font16->loadFrames(bmp, 1, 0, 1, 18);
	font16->loadFrames(bmp, 2, 0, 2, 17);
	font16->loadFrames(bmp, 3, 0, 3, 15);
	Sprite::setLoadPos(MOUSE_LOAD_X, MOUSE_LOAD_Y);
	mouse->loadFrames(bmp, 0, 0, 0, 8);
	mouse->setDInput(dinput);
	mouse->setDelay(1);

	bmp->load("map.bmp");
	Sprite::setLoadPos(0, 0);
	tileBlack->loadFrame(bmp, 0, 0, 0);
	if(map->init()==FALSE) return FALSE;
	if(map->loadTile(bmp, 0, 1)==FALSE) return FALSE;
	Sprite::setLoadPos(TITLE_LOAD_X, TITLE_LOAD_Y);
	title->loadFrame(bmp, 0, 0, 0);

	bmp->load("pacman.bmp");
	Sprite::setLoadPos(PACMAN_LOAD_X, PACMAN_LOAD_Y);
	pacman->loadFrames(bmp, 0, 0, 0, 8);
	pacman->loadFrames(bmp, 1, 0, 1, 8);
	pacman->loadFrames(bmp, 2, 0, 2, 8);
	pacman->loadFrames(bmp, 3, 0, 3, 8);
	pacman_dead->loadFrames(bmp, 0, 0, 4, 12);
	pacman_dead->setDelay(2);
	portal1->loadFrames(bmp, 0, 0, 5, 12);
	portal2->loadFrames(bmp, 0, 0, 6, 12);
	portalGhost->loadFrames(bmp, 0, 0, 7, 12);
	Sprite::setLoadPos(GHOST_LOAD_X, GHOST_LOAD_Y);
	loadGhost(bmp);
	Sprite::setLoadPos(PARTICLE_LOAD_X, PARTICLE_LOAD_Y);
	loadParticle(bmp);
	Sprite::setLoadPos(SMILEY_LOAD_X, SMILEY_LOAD_Y);
	smiley->loadFrame(bmp, 0, 0, 0);
	Pikachu::setLoadPos(PIKACHU_LOAD_X, PIKACHU_LOAD_Y);
	pikachu->loadFrames(bmp, 0, 0, 0, 2);
	bmp->release();

	if(Component::setDInput(dinput)==FALSE) return FALSE;
	if(Component::setFont(font16)==FALSE) return FALSE;
	
	buildSinCosTable(); // , ڻ   ̺ 
	setClipRect(0, 0, 640, 480); // Ŭ  

	gameMenu = GAME_MENU;

	return TRUE;
}


void GameShutdown()
{
	bmp->release();
	deleteSound();
	deleteMidi();
	deleteGhost();
	deleteParticle();
	delete pacman;
	delete pacman_dead;
	delete pikachu;
	delete portal1;
	delete portal2;
	delete portalGhost;
	delete smiley;
	delete title;
	delete tileBlack;
	delete font;
	delete font16;
	delete mouse;
	delete map;
	delete bmp;
	delete ddraw;
	delete dinput;
}


void GameMain()
{
	BOOL exit = FALSE;
	map->setCurrStage(0);
	map->initStage();

	while(!exit){
		Message_Pump();
		switch(gameMenu){
		default:
		case GAME_MENU:
			gameMenu = GameMenu();
			break;
		case GAME_PLAY:
			gameMenu = GamePlay();
			break;
		case GAME_EDIT:
			gameMenu = GameEdit();
			break;
		case GAME_CREDIT:
			gameMenu = GameCredit();
			break;
		case GAME_EXIT:
			exit = TRUE;
			break;
		}
	}
}

