/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "font.h"


Font::Font()
{
	index = 0;
	width = FONT_WIDTH;
	height = FONT_HEIGHT;
}


Font::Font(int width, int height)
{
	index = 0;
	this->width = width;
	this->height = height;
}


void Font::drawChar(char ch, int x, int y)
{
	setPos(x, y);
	if(ch>='a') ch -= 32;
	if(ch>='A' && ch<='M'){
		setAni(0);
		ch -= 'A';
	}
	else if(ch>='N' && ch<='_'){
		setAni(1);
		ch -= 'N';
	}
	else if(ch>='0' && ch<='@'){
		setAni(2);
		ch -= '0';
	}
	else{
		setAni(3);
		ch -= '!';
	}
	renderFrame(ch);
}


void Font::drawString(char *s, int x, int y)
{
	if(s){
		index = 0;
		while(s[index]){
			drawChar(s[index], x, y);
			++index;
			x += width;
		}
	}
}


void Font::drawCharClip(char ch, int x, int y)
{
	setPos(x, y);
	if(ch>='a') ch -= 32;
	if(ch>='A' && ch<='M'){
		setAni(0);
		ch -= 'A';
	}
	else if(ch>='N' && ch<='_'){
		setAni(1);
		ch -= 'N';
	}
	else if(ch>='0' && ch<='@'){
		setAni(2);
		ch -= '0';
	}
	else{
		setAni(3);
		ch -= '!';
	}
	renderFrameClip(ch);
}


void Font::drawStringClip(char *s, int x, int y)
{
	if(s){
		index = 0;
		while(s[index]){
			drawCharClip(s[index], x, y);
			++index;
			x += width;
		}
	}
}


void Font::drawCharFast(char ch, int x, int y)
{
	setPos(x, y);
	if(ch>='a') ch -= 32;
	if(ch>='A' && ch<='M'){
		setAni(0);
		ch -= 'A';
	}
	else if(ch>='N' && ch<='_'){
		setAni(1);
		ch -= 'N';
	}
	else if(ch>='0' && ch<='@'){
		setAni(2);
		ch -= '0';
	}
	else{
		setAni(3);
		ch -= '!';
	}
	renderFrameFast(ch);
}


void Font::drawStringFast(char *s, int x, int y)
{
	if(s){
		index = 0;
		while(s[index]){
			drawCharFast(s[index], x, y);
			++index;
			x += width;
		}
	}
}


/*void Font::setFontColor(int color)
{
	if(color < 0) color = 0;
	if(color > FontColor_Blue) color = FontColor_Blue;
	font_color = color;
}*/
