/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "map.h"


/*  Ŭ  ޼ҵ */
Map::Map()
{
	//  ü ʱȭ
	memset(stage, 0, sizeof(stage));
	currStage = 0;
	row = col = val = 0;
	for(int index=0; index < MAX_TILE; index++) tile[index] = NULL;
}


Map::~Map()
{
	for(int index=0; index < MAX_TILE; index++){
		if(tile[index]){
			delete tile[index];
			tile[index] = NULL;
		}
	}
}


BOOL Map::init()
{
	//   Ʈ 
	for(int index=0; index < MAX_TILE; index++){
		tile[index] = new Sprite(TILE_WIDTH, TILE_HEIGHT);
		if(tile[index] == NULL) return FALSE;
	}
	return TRUE;
}


BOOL Map::loadTile(BMP *bmp, int x, int y)
{
	for(row=0; row < MAX_TILE; row++){
		if(!tile[row]->loadFrames(bmp, 0, x, y+row, MAX_TILE_FRAME)) return FALSE;
	}
	return TRUE;
}


BOOL Map::save(char *mapfile)
{
	FILE *fp;

	fp = fopen(mapfile, "wb");
	if(fp == NULL) return FALSE;

	fputs(MapFileInfo, fp);
	fwrite(stage, 1, sizeof(stage), fp);

	fclose(fp);
	return TRUE;
}


BOOL Map::load(char *mapfile)
{
	FILE *fp;
	char buffer[30];

	fp = fopen(mapfile, "rb");
	if(fp == NULL) return FALSE;

	fgets(buffer, sizeof(MapFileInfo), fp);
	if(strcmp(buffer, MapFileInfo) != 0) return FALSE;
	if(fread(stage, 1, sizeof(stage), fp) != sizeof(stage)) return FALSE;

	fclose(fp);

	return TRUE;
}


void Map::initStage()
{
	//  ʱȭ
	for(row=0; row < STAGE_ROWS; row++){
		stage[currStage].tile[row][0] = 1;
		stage[currStage].tile[row][STAGE_COLS-1] = 1;
	}
	for(col=0; col < STAGE_COLS; col++){
		stage[currStage].tile[0][col] = 1;
		stage[currStage].tile[STAGE_ROWS-1][col] = 1;
	}
	// Ÿ ȯ,   
	stage[currStage].numEgg = 0;
	stage[currStage].numPowerup = 0;
	for(row=0; row < STAGE_ROWS; row++){
		for(col=0; col < STAGE_COLS; col++){
			convertTile(row, col);
			if(getTile(row,col)==-1){
				if(++stage[currStage].numPowerup > MAX_POWERUP) stage[currStage].numPowerup = MAX_POWERUP;
			}
			else if(getTile(row,col)==-2){
				if(++stage[currStage].numEgg > MAX_EGG) stage[currStage].numEgg = MAX_EGG;
			}
		}
	}
	currTileSet = stage[currStage].tileSet;
}


BOOL Map::drawStage() //   ׸
{
	if(currStage<0 || currStage>=MAX_STAGE) return FALSE;

	for(row=0; row < STAGE_ROWS; row++){
		for(col=0; col < STAGE_COLS; col++){
			val = stage[currStage].tile[row][col];
			if(val>0){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(val);
			}
			else if(val==-1){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(1);
			}
			else if(val==-2){
				tile[currTileSet]->setPos(col*TILE_WIDTH, row*TILE_HEIGHT + STAGE_Y);
				tile[currTileSet]->renderFrameFast(0);
			}
		}
	}
	return TRUE;
}


void Map::setCurrStage(int s)
{
	if(s<0 || s>=MAX_STAGE) currStage = 0;
	else currStage = s;
	currTileSet = stage[currStage].tileSet;
}


int Map::getCurrStage()
{
	return currStage;
}


void Map::setCurrTileSet(int t)
{
	if(t<0 || t>=MAX_TILE) t = 0;
	stage[currStage].tileSet = t;
}


void Map::setTile(int r, int c, int v)
{
	stage[currStage].tile[r][c] = v;
}


int Map::getTile(int r, int c)
{
	return stage[currStage].tile[r][c];
}


void Map::convertTile(int r, int c)
{
	val = 0;
	if(stage[currStage].tile[r][c]>0){
		if(r>0 && stage[currStage].tile[r-1][c]>0) val |= TILE_UP;
		if(r<STAGE_ROWS-1 && stage[currStage].tile[r+1][c]>0) val |= TILE_DOWN;
		if(c>0 && stage[currStage].tile[r][c-1]>0) val |= TILE_LEFT;
		if(c<STAGE_COLS-1 && stage[currStage].tile[r][c+1]>0) val |= TILE_RIGHT;
		stage[currStage].tile[r][c] = val+2;
	}
}


Sprite *Map::getTileSprite(int index)
{
	if(index >= MAX_TILE) index = MAX_TILE - 1;
	return tile[index];
}


Stage *Map::getStage(int index)
{
	if(index >= MAX_STAGE) index = MAX_STAGE - 1;
	return &stage[index];
}
