#ifndef __map_h_included__
#define __map_h_included__

#include "dx\Sprite.h"
#include "dx\bmp.h"
#include "unit.h"

#define MAX_STAGE		100
#define STAGE_X			0
#define STAGE_Y			24
#define STAGE_WIDTH		504
#define STAGE_HEIGHT	456

#define MAX_TILE		10
#define MAX_TILE_FRAME	18
#define TILE_WIDTH		24
#define TILE_HEIGHT		24

#define TILE_RIGHT	1 // 0001
#define TILE_UP		2 // 0010
#define TILE_LEFT	4 // 0100
#define TILE_DOWN	8 // 1000

#define MAX_EGG		300
#define MAX_POWERUP	9

#define MAX_ITEM	10 // ӽ
// TILE 
// 0, 1=RIGHT, 2=UP, 3=RIGHT|UP, 4=LEFT, 5=RIGHT|LEFT, 6=UP|LEFT, 7=RIGHT|UP|LEFT
// 8=DOWN, 9=RIGHT|DOWN, 10=UP|DOWN, 11=RIGHT|UP|DOWN, 12=LEFT|DOWN, 13=RIGHT|LEFT|DOWN, 14=UP|LEFT|DOWN, 15=RIGHT|UP|LEFT|DOWN

const int INTERVAL_WIDTH = (UNIT_WIDTH - TILE_WIDTH)>>1;
const int INTERVAL_HEIGHT = (UNIT_HEIGHT - TILE_HEIGHT)>>1;

const int MIDDLE_STAGE_WIDTH = (STAGE_WIDTH>>1) + STAGE_X;
const int MIDDLE_STAGE_HEIGHT = (STAGE_HEIGHT>>1) + STAGE_Y;

const int STAGE_ROWS = (STAGE_HEIGHT/TILE_HEIGHT);	// 19 
const int STAGE_COLS = (STAGE_WIDTH/TILE_WIDTH);	// 21 
const char MapFileInfo[] = "PacMan Map File";


//  ü
typedef struct STAGE_TYPE
{
	char tile[STAGE_ROWS][STAGE_COLS]; // Ÿ[][]
	char tileSet; // Ÿ Ʈ ȣ
	char pacmanRow, pacmanCol; // Ѹ ġ(,)
	char ghostRow, ghostCol; // Ʈ ġ(,)
	char portal1Row, portal1Col; // Ż1 ġ(,)
	char portal2Row, portal2Col; // Ż2 ġ(,)
	//char itemRow[MAX_ITEM], itemCol[MAX_ITEM]; //  ġ(,), 
	int numEgg, numPowerup; //  
	//BOOL isValid; //   ȿ ˻
} Stage;


//  Ŭ
class Map
{
public:
	Stage stage[MAX_STAGE]; //   ü 迭
	Sprite *tile[MAX_TILE]; //  ϴ Ÿ Ʈ
	int currStage; //  
	int currTileSet; //  Ÿ Ʈ
	int row, col, val; // ݺ  ,  , Ÿ 
public:
	Map();
	~Map();
	BOOL init();
	BOOL loadTile(BMP *bmp, int x, int y);
	BOOL save(char *mapfile);
	BOOL load(char *mapfile);
	void initStage();
	BOOL drawStage();
	void convertTile(int r, int c);
	void setCurrStage(int s);
	void setCurrTileSet(int t);
	void setTile(int r, int c, int v);
	int getCurrStage();
	int getTile(int r, int c);
	Sprite *getTileSprite(int index);
	Stage *getStage(int index);
};

#endif