/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "midi.h"

#define MAX_MIDI_INTERVAL 10

static DMusic *dmusic = NULL;
static BOOL musicOK = FALSE;


void initMidi(HWND hwnd)
{
	dmusic = new DMusic;

	if(!dmusic->init(hwnd)) musicOK = FALSE;
	else musicOK = TRUE;
}


void deleteMidi()
{
	if(dmusic) delete dmusic;
}


BOOL loadMidi()
{
	if(!musicOK) return FALSE;
	if(dmusic->loadMIDI("Menu.mid")<0) return FALSE;
	if(dmusic->loadMIDI("Play.mid")<0) return FALSE;
	return TRUE;
}


void playMidi(int id)
{
	if(musicOK && id>0){
		dmusic->play(--id);
	}
}


void loopMidi(int id)
{
	static count = 0;

	if(musicOK && id>0){
		--id;
		if(dmusic->getStatusMIDI(id)!=MIDI_PLAYING){
			if(++count > MAX_MIDI_INTERVAL){
				count = 0;
				dmusic->play(id);
			}
		}
	}
}


void stopMidi(int id)
{
	if(musicOK && id>0){
		dmusic->stop(--id);
	}
}
