/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "mouse.h"

// ܺ  
extern int screenWidth;
extern int screenHeight;


Mouse::Mouse()
{
	width = MOUSE_WIDTH;
	height = MOUSE_HEIGHT;
}


Mouse::Mouse(int width, int height)
{
	this->width = width;
	this->height = height;
}


void Mouse::setDInput(DInput *di)
{
	if(di) dinput = di;
}


void Mouse::setPos(int x, int y)
{
	this->x = x;
	this->y = y;
	dinput->setMousePos(x, y);
}


void Mouse::draw()
{
	x = dinput->mouseX;
	y = dinput->mouseY;
	if(x<0 || x+width>=screenWidth){
		dinput->mouseX = x = oldX;
	}
	if(y<0 || y+height>=screenHeight){
		dinput->mouseY = y = oldY;
	}
	renderFrame();
	oldX = x;
	oldY = y;
}


BOOL Mouse::isMoving()
{
	if(dinput->mouseX != dinput->mouseOldX || dinput->mouseY != dinput->mouseOldY) return TRUE;
	return FALSE;
}


BOOL Mouse::isPressed()
{
	if(dinput->mouseStateLB==MOUSE_PRESSED) return TRUE;
	return FALSE;
}


BOOL Mouse::isClicked()
{
	if(dinput->mouseStateLB==MOUSE_CLICKED) return TRUE;
	return FALSE;
}


BOOL Mouse::isDragged()
{
	if(dinput->mouseStateLB==MOUSE_DRAGGED) return TRUE;
	return FALSE;
}


BOOL Mouse::isDraggedRB()
{
	return (dinput->mouseRB);
}
