/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "particle.h"
#include "dx\Sprite.h"
#include "dx\Math.h"

#define PARTICLE_WIDTH		8
#define PARTICLE_HEIGHT		8

#define PARTICLE_STATE_DEAD		0
#define PARTICLE_STATE_ALIVE	1

#define MAX_COUNT		50


static Particle *particle[MAX_PARTICLE];
static int index;

int Particle::wind = 0;
int Particle::gravity = 0;


// ƼŬ Ŭ  ޼ҵ
Particle::Particle()
{
	width = PARTICLE_WIDTH;
	height = PARTICLE_HEIGHT;
	state = PARTICLE_STATE_DEAD;
	delay = 1;
}


void Particle::init(int wind, int gravity)
{
	Particle::wind = wind;
	Particle::gravity = gravity;
}


void Particle::start(int x, int y, int xv, int yv)
{
	state = PARTICLE_STATE_ALIVE;
	this->x = x;
	this->y = y;
	this->xv = xv;
	this->yv = yv;
	count = 0;
}


void Particle::move()
{
	if(state){
		x += xv;
		y += yv;
		xv += wind;
		yv += gravity;

		if (++count >= MAX_COUNT){
			state = PARTICLE_STATE_DEAD; // kill the particle
		}
		else if (x+width<0 || x>SCREEN_WIDTH || y>SCREEN_HEIGHT){
			state = PARTICLE_STATE_DEAD; // kill the particle
		}
	}
}


void Particle::draw()
{
	if(state) renderFrameClip();
}


void Particle::setWind(int wind)
{
	Particle::wind = wind;
}


void Particle::setGravity(int gravity)
{
	Particle::gravity = gravity;
}


//  Լ
void initParticle()
{
	for(index=0; index < MAX_PARTICLE; index++){
		particle[index] = new Particle;
	}
	particle[0]->init(0, 1);
}


void deleteParticle()
{
	for(index=0; index < MAX_PARTICLE; index++){
		if(particle[index]) delete particle[index];
	}
}


void loadParticle(BMP *bmp)
{
	particle[0]->loadFrames(bmp, 0, 0, 0, 22);
	particle[0]->loadFrames(bmp, 1, 0, 1, 22);
	particle[0]->loadFrames(bmp, 2, 0, 2, 22);
	particle[0]->loadFrames(bmp, 3, 0, 3, 22);
	for(index=1; index < MAX_PARTICLE; index++){
		particle[index]->getFrames(particle[0]);
	}
}


void startBigBang(int x, int y, int num, int r1, int r2, int color)
{
// this function starts a particle explosion at the given position and velocity
// note the use of look up tables for sin,cos

	// compute random velocity on outside of loop
	static int ang, vel;
	while(--num >=0)
    {
		// compute random trajectory angle
		ang = rand()%360;
		vel = (r1==r2) ? r1 : RAND_RANGE(r1, r2);
		createParticle(x, y, (int)(cos_ref[ang]*vel), (int)(sin_ref[ang]*vel), color);
    }
}


void createParticle(int x, int y, int xv, int yv, int color)
{
	int pindex = -1;
	// first find open particle
	for (int index=0; index < MAX_PARTICLE; index++)
		if (particle[index]->state == PARTICLE_STATE_DEAD)
		{
			pindex = index;
			break;
		}
	if (pindex==-1) return;
	
	particle[pindex]->start(x, y, xv, yv);
	particle[pindex]->setAni(color);
}


void moveParticle()
{
	for(index=0; index < MAX_PARTICLE; index++)
	{
		particle[index]->move();
	}
}


void drawParticle()
{
	for (index=0; index < MAX_PARTICLE; index++)
	{
		particle[index]->draw();
    }
}
