/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "unit.h"
#include "map.h"
#include "dx\math.h"


// ܺ  
extern Map *map;


int Unit::tempX = 0;
int Unit::tempY = 0;
int Unit::targetX = 0;
int Unit::targetY = 0;


//  Ŭ  ޼ҵ
Unit::Unit()
{
	state = SPRITE_STATE_ALIVE;
	width = UNIT_WIDTH;
	height = UNIT_HEIGHT;
	x = 0;
	y = 0;
	yv = xv = UNIT_SPEED;
	delay = 1;

	stateAI = 0;
	move_count = 0;
	dir = old_dir = DIR_RIGHT;
	dir_changed = FALSE;
	count = 0;
	ani_count = 0;
}


void Unit::setRC(int row, int col)
{
	x = col*TILE_WIDTH - INTERVAL_WIDTH;
	y = row*TILE_HEIGHT - INTERVAL_HEIGHT + STAGE_Y;
}


void Unit::setDir(int dir)
{
	this->dir = dir;
}


void Unit::setSpeed(int speed)
{
	xv = yv = speed;
}


void Unit::setTarget(int x, int y)
{
	targetX = x;
	targetY = y;
}


void Unit::setTarget(Unit *target) // ǥ  
{
	targetX = target->x;
	targetY = target->y;
}


void Unit::move()
{
	if(dir != old_dir){
		if(((x+INTERVAL_WIDTH)%TILE_WIDTH==0)&&((y+INTERVAL_HEIGHT-STAGE_Y)%TILE_HEIGHT==0)){
			if(canMove(dir)){
				old_dir = dir;
				dir_changed = TRUE;
			}
		}
	}
	if(canMove(old_dir)){
		switch(old_dir){
		case DIR_RIGHT:
			x += xv;
			break;
		case DIR_UP:
			y -= yv;
			break;
		case DIR_LEFT:
			x -= xv;
			break;
		case DIR_DOWN:
			y += yv;
			break;
		default:
			break;
		}
	}
}


BOOL Unit::canMove(int dir)
{
	static int r, c;
	tempX = x + INTERVAL_WIDTH;
	tempY = y + INTERVAL_HEIGHT - STAGE_Y;

	switch(dir){
	case DIR_RIGHT:
		tempX += (TILE_WIDTH);
		break;
	case DIR_UP:
		tempY -= yv;
		break;
	case DIR_LEFT:
		tempX -= xv;
		break;
	case DIR_DOWN:
		tempY += (TILE_HEIGHT);
		break;
	default:
		break;
	}

	r = tempY/TILE_HEIGHT;
	c = tempX/TILE_WIDTH;
	if(map->getTile(r,c) > 0) return FALSE;

	return TRUE;
}


void Unit::resetPos()
{
	x = ((x+INTERVAL_WIDTH)/TILE_WIDTH)*TILE_WIDTH-INTERVAL_WIDTH;
	y = ((y+INTERVAL_HEIGHT-STAGE_Y)/TILE_HEIGHT)*TILE_HEIGHT-INTERVAL_HEIGHT+STAGE_Y;
}


BOOL Unit::testCollision(Unit *unit)
{
	if(unit==this) return FALSE;
	
	w1 = width>>2;
	h1 = height>>2;
	w2 = unit->width>>2;
	h2 = unit->height>>2;
	dx = (x+w1) - (unit->x+w2);
	dy = (y+h1) - (unit->y+h2);
	if(dx < 0) dx = -dx;
	if(dy < 0) dy = -dy;

	if(dx >= w1+w2) return FALSE;
	if(dy >= h1+h2) return FALSE;
	return TRUE;
}

