/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "unit_ghost.h"
#include "pacman.h"
#include "dx\Math.h"
#include "gui\gui.h"
#include "sound.h"
#include "map.h"
#include "unit_pacman.h"
#include "unit_portal.h"

#define GHOST_SPEED_SLOW	1
#define GHOST_SPEED_NORMAL	3
#define GHOST_SPEED_FAST	4
#define GHOST_SPEED_FASTEST	24

#define MAX_COUNT_GHOST_ANGRY		20
#define MAX_COUNT_GHOST_WEAK		10
#define MAX_COUNT_GHOST_CHANGE		5


// ܺ 
extern Pacman *pacman;
extern Portal *portal1;
extern Portal *portal2;
extern Portal *portalGhost;
extern Stage stage;
extern Label *bonusScoreLabel;
extern Button *excellentButton;
extern int bonusScore;
extern int scoreCount;


//  
Ghost *ghost[MAX_GHOST], *ghost_dead, *ghost_angry, *ghost_weak;

// ƽ 
static int index;

static int aiTableNormal[10] = { AI_CHASE, AI_CHASE, AI_CHASE, AI_RANDOM, AI_RANDOM,
	AI_RANDOM, AI_RANDOM, AI_RANDOM, AI_RANDOM, AI_RANDOM };

static int aiTableAngry[10] = { AI_CHASE, AI_CHASE, AI_CHASE, AI_CHASE, AI_CHASE,
	AI_CHASE, AI_RANDOM, AI_RANDOM, AI_RANDOM, AI_RANDOM };

static int aiTableWeak[10] = { AI_RUNAWAY, AI_RUNAWAY, AI_RUNAWAY, AI_RUNAWAY, AI_RUNAWAY,
	AI_RUNAWAY, AI_RUNAWAY, AI_RANDOM, AI_RANDOM, AI_RANDOM };


int Ghost::numCaughtGhosts = 0;


// Ʈ Ŭ  ޼ҵ
Ghost::Ghost()
{
	init();
}


void Ghost::init()
{
	state = GHOST_STATE_NORMAL;
	dir = RAND_RANGE(DIR_RIGHT, DIR_DOWN);
	angryCount = weakCount = 0;
}


void Ghost::move()
{

	static int count = 0;

	setTarget(pacman);

	switch(state){
	case GHOST_STATE_DEAD:
		setTarget(portalGhost);
		xv = yv = GHOST_SPEED_FASTEST;
		stateAI = aiTableAngry[rand()%10];
		break;
	case GHOST_STATE_NORMAL:
		xv = yv = GHOST_SPEED_NORMAL;
		stateAI = aiTableNormal[rand()%10];
		break;
	case GHOST_STATE_ANGRY:
		xv = yv = GHOST_SPEED_FAST;
		stateAI = aiTableAngry[rand()%10];
		break;
	case GHOST_STATE_ANGRY2NORMAL:
		xv = yv = GHOST_SPEED_NORMAL;
		stateAI = aiTableAngry[rand()%10];
		break;
	case GHOST_STATE_WEAK:
	case GHOST_STATE_WEAK2NORMAL:
		xv = yv = GHOST_SPEED_SLOW;
		stateAI = aiTableWeak[rand()%10];
		break;
	default:
		break;
	}

	switch(stateAI){
	case AI_RANDOM:
		while(1){
			dir = RAND_RANGE(DIR_RIGHT, DIR_DOWN);
			if(ABS(dir-old_dir)!=2) break;
		}
		if(!canMove(dir)) dir = old_dir;
		break;
	case AI_CHASE:
		if(old_dir==DIR_RIGHT || old_dir==DIR_LEFT){
			if(y>targetY) dir = DIR_UP;
			else if(y<targetY) dir = DIR_DOWN;
			if(!canMove(dir)){
				if(x>targetX) dir = DIR_LEFT;
				else if(x<targetY) dir = DIR_RIGHT;
				else dir = old_dir;
			}
		}
		else{
			if(x>targetX) dir = DIR_LEFT;
			else if(x<targetX) dir = DIR_RIGHT;
			if(!canMove(dir)){
				if(y>targetY) dir = DIR_UP;
				else if(y<targetY) dir = DIR_DOWN;
				else dir = old_dir;
			}
		}
		break;
	case AI_RUNAWAY:
		if(old_dir==DIR_RIGHT || old_dir==DIR_LEFT){
			if(y>targetY) dir = DIR_DOWN;
			else if(y<targetY) dir = DIR_UP;
			if(!canMove(dir)){
				if(x>targetX) dir = DIR_RIGHT;
				else if(x<targetX) dir = DIR_LEFT;
				else dir = old_dir;
			}
		}
		else{
			if(x>targetX) dir = DIR_RIGHT;
			else if(x<targetX) dir = DIR_LEFT;
			if(!canMove(dir)){
				if(y>targetY) dir = DIR_DOWN;
				else if(y<targetY) dir = DIR_UP;
				else dir = old_dir;
			}
		}
		break;
	}

	while(!canMove(dir)){
		if(++dir>DIR_DOWN) dir = DIR_RIGHT;
		if(++count>3){
			count = 0;
			break;
		}
	}
	Unit::move();
}


void Ghost::control()
{
	switch(state){
	case GHOST_STATE_WEAK:
	case GHOST_STATE_WEAK2NORMAL:
		if(testCollision(pacman)){
			state = GHOST_STATE_DEAD;
			pacman->score += (bonusScore<<=1);
			pacman->tempScore += bonusScore;
			resetPos();
			bonusScoreLabel->setPos(x, y+8);
			bonusScoreLabel->setVisible(TRUE);
			scoreCount = 0;
			playSound(RAND_RANGE(SOUND_EATGHOST, SOUND_KILL));
			switch(++numCaughtGhosts){
			case 1:
				bonusScoreLabel->setLabel("200");
				break;
			case 2:
				bonusScoreLabel->setLabel("400");
				break;
			case 3:
				bonusScoreLabel->setLabel("800");
				break;
			case 4:
				bonusScoreLabel->setLabel("1600");
				excellentButton->setVisible(TRUE);
				playSound(SOUND_EXCELLENT);
				break;
			}
		}
		break;
	case GHOST_STATE_NORMAL:
	case GHOST_STATE_ANGRY:
	case GHOST_STATE_ANGRY2NORMAL:
		if(testCollision(pacman)){
			pacman->setState(PACMAN_STATE_DYING);
			playSound(RAND_RANGE(SOUND_OUCH, SOUND_OUCH2));
		}
		break;
	}

	if(!((x+INTERVAL_WIDTH)%TILE_WIDTH) && !((y+INTERVAL_HEIGHT-STAGE_Y)%TILE_HEIGHT)){
		switch(state){
		case GHOST_STATE_DEAD:
			if(testCollision(portalGhost)){
				state = GHOST_STATE_ANGRY;
				angryCount = 0;
			}
			break;
		case GHOST_STATE_ANGRY:
			if(++angryCount > MAX_COUNT_GHOST_ANGRY){
				state = GHOST_STATE_ANGRY2NORMAL;
				angryCount = 0;
			}
			break;
		case GHOST_STATE_ANGRY2NORMAL:
			if(++angryCount > MAX_COUNT_GHOST_CHANGE){
				state = GHOST_STATE_NORMAL;
				angryCount = 0;
			}
			break;
		case GHOST_STATE_WEAK:
			if(++weakCount > MAX_COUNT_GHOST_WEAK){
				state = GHOST_STATE_WEAK2NORMAL;
				weakCount = 0;
			}
			break;
		case GHOST_STATE_WEAK2NORMAL:
			if(++weakCount > MAX_COUNT_GHOST_CHANGE){
				state = GHOST_STATE_NORMAL;
				weakCount = 0;
				numCaughtGhosts = 0;
				bonusScore = 100;
			}
			if(!isPlaying(SOUND_COUNT)) playSound(SOUND_COUNT);
			break;
		default:
			break;
		}
		if(testCollision(portal1)){
			setRC(stage.portal2Row, stage.portal2Col);
			playSound(SOUND_PORTAL);
		}
		else if(testCollision(portal2)){
			setRC(stage.portal1Row, stage.portal1Col);
			playSound(SOUND_PORTAL);
		}
	}
}


void Ghost::draw()
{
	if(dir_changed){
		setAni(old_dir);
		dir_changed = FALSE;
	}
	switch(state){
	case GHOST_STATE_DEAD:
		ghost_dead->setAni(old_dir);
		ghost_dead->setPos(x, y);
		ghost_dead->renderFrame();
		break;
	case GHOST_STATE_ANGRY:
		renderFrame();
		ghost_angry->setAni(old_dir);
		ghost_angry->setPos(x, y);
		ghost_angry->renderFrame();
		break;
	case GHOST_STATE_ANGRY2NORMAL:
		renderFrame();
		if(angryCount%2){
			ghost_angry->setAni(old_dir);
			ghost_angry->setPos(x, y);
			ghost_angry->renderFrame();
		}
		break;
	case GHOST_STATE_WEAK:
		ghost_weak->setPos(x, y);
		ghost_weak->renderFrame();
		break;
	case GHOST_STATE_WEAK2NORMAL:
		if(weakCount%2){
			ghost_weak->setPos(x, y);
			ghost_weak->renderFrame();
		}
		else renderFrame();
		break;
	default:
		renderFrame();
		break;
	}
}


void Ghost::setStateWeak()
{
	state = GHOST_STATE_WEAK;
	weakCount = 0;
}


//  Լ
void initGhost()
{
	ghost_dead = new Ghost;
	ghost_angry = new Ghost;
	ghost_weak = new Ghost;
	for(index=0; index<MAX_GHOST; index++){
		ghost[index] = new Ghost;
	}
}


void loadGhost(BMP *bmp)
{
	ghost_dead->loadFrames(bmp, 0, 0, 0, 6); // Right
	ghost_dead->loadFrames(bmp, 1, 6, 0, 6); // Up
	ghost_dead->loadFrames(bmp, 2, 0, 1, 6); // Left
	ghost_dead->loadFrames(bmp, 3, 6, 1, 6); // Down

	ghost_angry->loadFrames(bmp, 0, 0, 2, 6); // Right
	ghost_angry->loadFrames(bmp, 1, 6, 2, 6); // Up
	ghost_angry->loadFrames(bmp, 2, 0, 3, 6); // Left
	ghost_angry->loadFrames(bmp, 3, 6, 3, 6); // Down

	ghost_weak->loadFrames(bmp, 0, 0, 4, 12);

	for(index=0; index<MAX_GHOST; index++){
		ghost[index]->loadFrames(bmp, 0, 0, 5+index*2, 6);
		ghost[index]->loadFrames(bmp, 1, 6, 5+index*2, 6);
		ghost[index]->loadFrames(bmp, 2, 0, 6+index*2, 6);
		ghost[index]->loadFrames(bmp, 3, 6, 6+index*2, 6);
	}
}


void moveGhost()
{
	for(index=0; index<MAX_GHOST; index++){
		ghost[index]->move();
	}
}


void controlGhost()
{
	for(index=0; index<MAX_GHOST; index++){
		ghost[index]->control();
	}
}


void drawGhost()
{
	for(index=0; index<MAX_GHOST; index++){
		ghost[index]->draw();
	}
}


void deleteGhost()
{
	if(ghost_dead) delete ghost_dead;
	if(ghost_angry) delete ghost_angry;
	if(ghost_weak) delete ghost_weak;
	for(index=0; index<MAX_GHOST; index++){
		if(ghost[index]){
			delete ghost[index];
		}
	}
}
