/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "unit_pacman.h"
#include "dx\Math.h"
#include "sound.h"
#include "map.h"
#include "unit_ghost.h"
#include "unit_portal.h"

#define PACMAN_SPEED_NORMAL	3
#define PACMAN_SPEED_FAST	4

#define MAX_COUNT_PACMAN_DEAD	30


// ܺ  
extern Map *map;
extern Stage stage;
extern Pacman *pacman_dead;
extern Ghost *ghost[MAX_GHOST];
extern Portal *portal1;
extern Portal *portal2;
extern int bonusScore;

// ƽ 
static int index, tempX, tempY, row, col, val;


// Ѹ Ŭ  ޼ҵ
Pacman::Pacman()
{
	init();
}


void Pacman::init()
{
	state = PACMAN_STATE_NORMAL;
	xv = yv = PACMAN_SPEED_NORMAL;
	delay = 0;
	score = tempScore = 10;
	life = MAX_LIFE;
}


void Pacman::control()
{
	tempX = x+INTERVAL_WIDTH;
	tempY = y+INTERVAL_HEIGHT-STAGE_Y;
	if(!(tempX%TILE_WIDTH) && !(tempY%TILE_HEIGHT)){
		row = tempY/TILE_HEIGHT;
		col = tempX/TILE_WIDTH;
		val = stage.tile[row][col];
		if(val==-1){
			playSound(RAND_RANGE(SOUND_EATPOWER, SOUND_EATPOWER2));
			score += 50;
			tempScore += 50;
			--stage.numPowerup;
			stage.tile[row][col] = 0;
			for(index=0; index<MAX_GHOST; index++){
				val = ghost[index]->state;
				if(val != GHOST_STATE_DEAD) ghost[index]->setStateWeak();
			}
			Ghost::numCaughtGhosts = 0;
			bonusScore = 100;
		}
		else if(val==-2){
			playSound(SOUND_EATDOT);
			score += 10;
			tempScore += 10;
			--stage.numEgg;
			stage.tile[row][col] = 0;
		}
		if(!testCollision(portal1)){
			portal1->setActive(TRUE);
		}
		else if(portal1->isActive){
			playSound(SOUND_PORTAL);
			setRC(stage.portal2Row, stage.portal2Col);
			portal1->setActive(FALSE);
			portal2->setActive(FALSE);
		}
		if(!testCollision(portal2)){
			portal2->setActive(TRUE);
		}
		else if(portal2->isActive){
			playSound(SOUND_PORTAL);
			setRC(stage.portal1Row, stage.portal1Col);
			portal1->setActive(FALSE);
			portal2->setActive(FALSE);
		}
	}
}


void Pacman::draw()
{
	static int count = 0;

	switch(state){
	case PACMAN_STATE_DYING:
		pacman_dead->setPos(x, y);
		pacman_dead->renderFrame();
		if(++count>=36){
			count = 0;
			state = PACMAN_STATE_DEAD;
		}
		break;
	case PACMAN_STATE_DEAD:
		break;
	default:
		if(dir_changed){
			setAni(old_dir);
			dir_changed = FALSE;
		}
		renderFrame();
		break;
	}
}
