/*
Copyright 2002 Lee Soon Gyu

[In Korean]
 α׷ ̹Ƿ   ƴ ѵ
 뵵 ο    մϴ.
, α׷ Ͻ 쿡 ó (̼)
ݵ  ֽñ ٶϴ.

[In English]
This program is free software, so you can freely distribute it
and modify it without any commercial purpose.
When you distribute it, you should have to specify the author
of this program.

Written by Lee Soon Gyu (lsg0222@hanmail.net)
*/

#include "unit_pikachu.h"
#include "unit_pacman.h"
#include "dx\Math.h"
#include "sound.h"


// ܺ  
extern Pacman *pacman;
extern int gameCount;


#define MAX_COUNT_PIKACHU_BALL		300
#define MAX_COUNT_PIKACHU_NORMAL	100

// ƽ 
static int index, tempX, tempY, row, col, val;


// ī Ŭ  ޼ҵ
Pikachu::Pikachu()
{
	init();
}


void Pikachu::init()
{
	state = PIKACHU_STATE_DEAD;
	count = 0;
	numPikachu = 0;
}


void Pikachu::start(int row, int col)
{
	if(!state){
		setRC(row, col);
		state = PIKACHU_STATE_BALL;
		count = 0;
	}
}


void Pikachu::control()
{
	switch(state){
	case PIKACHU_STATE_BALL:
		if(++count > MAX_COUNT_PIKACHU_BALL){
			state = PIKACHU_STATE_DEAD;
			gameCount = 0;
		}
		if(testCollision(pacman)){
			playSound(RAND_RANGE(SOUND_PIKACHU, SOUND_PIKAPIKA));
			if(++numPikachu>MAX_PIKACHU) numPikachu = MAX_PIKACHU;
			state = PIKACHU_STATE_NORMAL;
			count = 0;
		}
		break;
	case PIKACHU_STATE_NORMAL:
		if(++count > MAX_COUNT_PIKACHU_NORMAL){
			state = PIKACHU_STATE_DEAD;
			gameCount = 0;
		}
		break;
	}
}


void Pikachu::draw()
{
	static int count = 0;

	switch(state){
	case PIKACHU_STATE_DEAD:
		break;
	case PIKACHU_STATE_BALL:
		renderFrame(0);
		break;
	case PIKACHU_STATE_NORMAL:
		renderFrame(1);
		break;
	}
}
