//-----------------------------------------------------------------------------------------
//CMediaPlayer.cpp
//
//2002.6.17 by p.s.k
//------------------------------------------------------------------------------------------


#include "CMediaPlayer.h"



CMEDIAPLAYER :: CMEDIAPLAYER()
{
        m_state=STOP;
        m_gb=NULL;
        m_mc=NULL;
        m_me=NULL;
        CoInitialize(NULL);
}

CMEDIAPLAYER :: ~CMEDIAPLAYER()
{
        Close();
        CoUninitialize();

}


void CMEDIAPLAYER ::Init(HWND hWnd ,  UINT uiMsg)
{
        CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, IID_IGraphBuilder, (void **)&m_gb);

        m_gb->QueryInterface(IID_IMediaControl, (void **)&m_mc);
        m_gb->QueryInterface(IID_IMediaEvent, (void **)&m_me);
        m_gb->QueryInterface(IID_IMediaSeeking, (void **)&m_ms);

        m_me->SetNotifyWindow((OAHWND)hWnd, uiMsg, 0);
}



void CMEDIAPLAYER :: Open(const char *szName)
{
        WORD wszName[256];
        MultiByteToWideChar(CP_ACP, 0, szName, -1, wszName, 256);
        m_gb->RenderFile(wszName, NULL);
        strcpy(m_szName, szName);
}//void CMEDIAPLAYER :: Open(const char *szName, HWND hWnd, UINT uiMsg)





void CMEDIAPLAYER :: Pause()
{
        if (!m_mc) return;
        switch (m_state)
        {
                case PLAY:
                        m_mc->Pause();
                        m_state=PAUSE;
                        break;
                case PAUSE:
                        Play();
                        break;
        }
}

void CMEDIAPLAYER :: Stop()
{
        if (!m_mc) return;
        m_mc->Stop();
        m_state=STOP;

        LONGLONG pos=0;
        m_ms->SetPositions(&pos, AM_SEEKING_AbsolutePositioning, NULL, AM_SEEKING_NoPositioning);
}

void CMEDIAPLAYER :: Close()
{
        Stop();
        SAFE_RELEASE(m_mc); // #define SAFE_RELEASE(p)  {if (p) p->Release();p=NULL;}
        SAFE_RELEASE(m_me);
		SAFE_RELEASE(m_ms);
        SAFE_RELEASE(m_gb);
}

bool CMEDIAPLAYER :: WMNotify()
{
        long evCode, evParm1, evParm2;

        while (SUCCEEDED(m_me->GetEvent(&evCode, &evParm1, &evParm2, 0)))
        {
                m_me->FreeEventParams(evCode, evParm1, evParm2);
                if (evCode==EC_COMPLETE) return false;
        }
        return true;
}

bool CMEDIAPLAYER :: Replay()
{
        Stop();
        return Play();
}

bool CMEDIAPLAYER :: Play()
{
        if (!m_mc) return false;
        if (FAILED(m_mc->Run())) return false;
        m_state=PLAY;
        return true;
}

bool CMEDIAPLAYER :: IsPause()
{
        if (m_state==PAUSE) return true;
        return false;
}

