///////////////////////////////////////////////////
//
// Matrix Palette 뿹
//
// 2002.6.23
//
// Owner : newtype@chollian.net
// Home  : http://newtype.xcool.net:3000
//
//

#include <d3dx8.h>
#include <mmsystem.h>

LPDIRECT3D8             g_pD3D       = NULL;
LPDIRECT3DDEVICE8       g_pd3dDevice = NULL;
LPDIRECT3DVERTEXBUFFER8 g_pVB        = NULL;
LPDIRECT3DINDEXBUFFER8	g_pIB        = NULL;

struct MYVERTEX
{
    float	x, y, z;
    float	w1, w2, w3;		// blending weight 1, 2, 3 and 4th = 1.0 - (1th + 2th + 3th)
	DWORD	index;			// matrix palette index, w1 matrix palette index Ʈ, w2   Ʈ
    DWORD	diffuse;		// ڼ  DX8.1 Help Vertex Formats׸ Advanced Topics/Indexed Vertex Blending 
};

struct MYINDEX
{
	WORD	i1, i2, i3;		// ﰢ ׸  index
};

#define D3DFVF_MYVERTEX (D3DFVF_XYZB4 | D3DFVF_LASTBETA_UBYTE4 | D3DFVF_DIFFUSE)		// blend weight 4 

HRESULT InitD3D( HWND hWnd )
{
    if( NULL == ( g_pD3D = Direct3DCreate8( D3D_SDK_VERSION ) ) )
        return E_FAIL;

    D3DDISPLAYMODE d3ddm;
    if( FAILED( g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
        return E_FAIL;

    D3DPRESENT_PARAMETERS d3dpp; 
    ZeroMemory( &d3dpp, sizeof(d3dpp) );
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
    d3dpp.BackBufferFormat = d3ddm.Format;
    d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;		// Zۻ

    if( FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
                                      D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                                      &d3dpp, &g_pd3dDevice ) ) )
    {
        return E_FAIL;
    }

    g_pd3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );					// z 
    g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );			// culling
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );					//  
    g_pd3dDevice->SetRenderState( D3DRS_INDEXEDVERTEXBLENDENABLE, TRUE );	// matrix palette 
    g_pd3dDevice->SetRenderState( D3DRS_VERTEXBLEND, D3DVBF_3WEIGHTS );		// blend weight 4(Ÿ ƴ! 4!)


    return S_OK;
}

HRESULT InitGeometry()
{
    MYVERTEX Vertices[] =
    {
        { -1.0f,  1.0f,  1.0f,      0.5f, 0.5f, 0.0f, 1,    0xffff0000 },	// 0.5 * Vertex * mat0 + 0.5 * Vertex * mat1...
        {  1.0f,  1.0f,  1.0f,      0.5f, 0.5f, 0.0f, 1,    0xff00ff00 },
        {  1.0f,  1.0f, -1.0f,      0.5f, 0.5f, 0.0f, 1,    0xff0000ff },
        { -1.0f,  1.0f, -1.0f,      0.5f, 0.5f, 0.0f, 1,    0xffffff00 },

        { -1.0f, -1.0f,  1.0f,      1.0f, 0.0f, 0.0f, 0,    0xff00ffff },	// 1.0 * Vertex * mat0
        {  1.0f, -1.0f,  1.0f,      1.0f, 0.0f, 0.0f, 0,    0xffff00ff },
        {  1.0f, -1.0f, -1.0f,      1.0f, 0.0f, 0.0f, 0,    0xff000000 },
        { -1.0f, -1.0f, -1.0f,      1.0f, 0.0f, 0.0f, 0,    0xffffffff },
    };

	MYINDEX Indices[] =
	{
		{ 0, 1, 2 },
		{ 0, 2, 3 },
		{ 3, 2, 7 },
		{ 7, 2, 6 },
		{ 2, 1, 5 },
		{ 6, 2, 5 },
		{ 4, 0, 3 },
		{ 4, 3, 7 },
		{ 1, 0, 4 },
		{ 4, 5, 1 },
		{ 7, 6, 5 },
		{ 5, 4, 7 }
	};

	// Matrix palette  Vertex۰ ݵ(!) Video Ram ־ TnL ޴´. ⼭ Ƽ ׳ default
    if( FAILED( g_pd3dDevice->CreateVertexBuffer( 8 * sizeof(MYVERTEX), 0, D3DFVF_MYVERTEX, D3DPOOL_DEFAULT, &g_pVB ) ) )
        return E_FAIL;
    VOID* pVertices;
    if( FAILED( g_pVB->Lock( 0, sizeof(Vertices), (BYTE**)&pVertices, 0 ) ) )
        return E_FAIL;
    memcpy( pVertices, Vertices, sizeof(Vertices) );
    g_pVB->Unlock();

	// Matrix palette  Index۰ ݵ(!) Video Ram ־ TnL ޴´. ⼭ Ƽ ׳ default
	g_pd3dDevice->CreateIndexBuffer( 12 * sizeof(MYINDEX),0 , D3DFMT_INDEX16, D3DPOOL_DEFAULT, &g_pIB );
    VOID* pIndices;
	g_pIB->Lock( 0, sizeof(Indices), (BYTE**)&pIndices, 0 );
    memcpy( pIndices, Indices, sizeof(Indices) );
    g_pIB->Unlock();

    return S_OK;
}

VOID Cleanup()
{
    if( g_pVB != NULL )
        g_pVB->Release();

    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();
}

VOID SetupMatrices()
{
    D3DXMATRIX matWorld;
    D3DXMatrixRotationY( &matWorld, timeGetTime()/600.0f );		// Y ȸ
    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

    D3DXMATRIX matView;
    D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 3.0f,-5.0f ),
                                  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ),
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
    g_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

    D3DXMATRIX matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.0f, 1.0f, 100.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );

	//--------------------------------------------------------------------------//
	D3DXMATRIX matW0;
	D3DXMATRIX matW1;
	D3DXMATRIX matW2;

	D3DXMatrixIdentity( &matW0 );
	D3DXMatrixIdentity( &matW1 );
	D3DXMatrixIdentity( &matW2 );
	matW0 = matWorld;					// W0 ϴ matrix palette 0 ȸ 

	g_pd3dDevice->SetTransform( D3DTS_WORLDMATRIX(0), &matW0 );
	g_pd3dDevice->SetTransform( D3DTS_WORLDMATRIX(1), &matW1 );
	g_pd3dDevice->SetTransform( D3DTS_WORLDMATRIX(2), &matW2 );
}

VOID Render()
{
    SetupMatrices();

    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(127,127,127), 1.0f, 0 );
    g_pd3dDevice->BeginScene();
	g_pd3dDevice->SetStreamSource( 0, g_pVB, sizeof(MYVERTEX) );
	g_pd3dDevice->SetIndices( g_pIB, 0 );
    g_pd3dDevice->SetVertexShader( D3DFVF_MYVERTEX );
    g_pd3dDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 8, 0, 12 );
    g_pd3dDevice->EndScene();

    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}

LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch( msg )
    {
        case WM_DESTROY:
            PostQuitMessage( 0 );
            return 0;
    }

    return DefWindowProc( hWnd, msg, wParam, lParam );
}

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
    WNDCLASSEX wc = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 0L,
                      GetModuleHandle(NULL), NULL, NULL, NULL, NULL,
                      "D3D Tutorial", NULL };
    RegisterClassEx( &wc );

    HWND hWnd = CreateWindow( "D3D Tutorial", "D3D Tutorial 03: Matrices",
                              WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 400, 400,
                              GetDesktopWindow(), NULL, wc.hInstance, NULL );

    if( SUCCEEDED( InitD3D( hWnd ) ) )
    {
        if( SUCCEEDED( InitGeometry() ) )
        {
            ShowWindow( hWnd, SW_SHOWDEFAULT );
            UpdateWindow( hWnd );

            MSG msg;
            ZeroMemory( &msg, sizeof(msg) );
            while( msg.message!=WM_QUIT )
            {
                if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
                {
                    TranslateMessage( &msg );
                    DispatchMessage( &msg );
                }
                else
                    Render();
            }
        }
    }

    Cleanup();
    UnregisterClass( "D3D Tutorial", wc.hInstance );
    return 0;
}



