// FileStream.h: interface for the CFileStream class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILESTREAM_H__6F6B0F2B_1E1C_4169_89D7_78EED10808E9__INCLUDED_)
#define AFX_FILESTREAM_H__6F6B0F2B_1E1C_4169_89D7_78EED10808E9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Unknown.h"

class CFileStream : public CUnknown  
{
public:
	typedef enum _MODE
	{
		CREATE = 0,
		READONLY,
		READWRITE,
	} MODE;

protected:
	FILE*	m_pFile;

public:
	CFileStream();
	virtual ~CFileStream();

	virtual bool Open(LPSTR lpszFileName, MODE mode);
	virtual void Close();

	virtual size_t Read(void* buffer, size_t size, size_t count);
	virtual size_t ReadString(void* buffer);

	virtual size_t Write(void* buffer, size_t size, size_t count);
	virtual size_t WriteString(void *buffer);

	virtual int ReadChar();
	virtual int WriteChar(int c);

	virtual int  Seek(long offset, int origin);
	virtual long Position();
};

#endif // !defined(AFX_FILESTREAM_H__6F6B0F2B_1E1C_4169_89D7_78EED10808E9__INCLUDED_)
