// FrameWnd.cpp: implementation of the CFrameWnd class.
//
//////////////////////////////////////////////////////////////////////
#define className	"GLSDK"
#define windowName	"OpenGL 1.2 Example"

#include "FrameWnd.h"

HWND CFrameWnd::m_hWnd = NULL;
BOOL CFrameWnd::m_bActive = FALSE;

static HRESULT WINAPI WndProc(HWND		hWnd, 
							  UINT		message, 
							  WPARAM	wParam, 
							  LPARAM	lParam)

{
    switch (message)
	{
    case WM_SETCURSOR:
        SetCursor(NULL);
        return 1;

    case WM_ACTIVATEAPP:
		CFrameWnd::m_bActive = wParam;
        break;

	case WM_KEYDOWN:									
        switch (wParam)
        {
            case VK_ESCAPE:
                PostMessage(CFrameWnd::m_hWnd, WM_CLOSE, 0, 0);
                break;
        }
		break;

	case WM_DESTROY:
        PostQuitMessage(0);
        break;

    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFrameWnd::CFrameWnd()
{
	m_pszClassName = "FrameWnd";

	///////////////////////////////////////////////////////////////////////////
	m_hDC = NULL;
}

CFrameWnd::~CFrameWnd()
{
	Destroy();
}

void CFrameWnd::Destroy()
{
	if (m_hDC)
	{
		ReleaseDC(m_hWnd, m_hDC);
		m_hDC = NULL;
	}

	if (m_hWnd)
	{
		DestroyWindow(m_hWnd);
		m_hWnd = NULL;
	}
}

bool CFrameWnd::Create(LPSTR lpszTitle, HINSTANCE hInstance, int nWidth, int nHeight)
{
    // Register Class
    WNDCLASS wc;

    wc.style            = 0;
    wc.lpfnWndProc      = WndProc;
    wc.cbClsExtra       = 0;
    wc.cbWndExtra       = 0;
    wc.hInstance        = hInstance;
    wc.hIcon            = LoadIcon(hInstance, IDI_APPLICATION);
    wc.hCursor          = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground    = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName     = NULL;
    wc.lpszClassName    = className;
    if (!RegisterClass(&wc))
        return false;

	// Create Window
	m_hWnd = ::CreateWindowEx(/*WS_EX_TOPMOST,/*/ WS_EX_OVERLAPPEDWINDOW,
							  className,
							  windowName,
							  WS_POPUP |
							  WS_CLIPSIBLINGS | 
							  WS_CLIPCHILDREN,
							  0,
							  0,
							  nWidth,
							  nHeight,
							  HWND_DESKTOP,
							  NULL,
							  hInstance,
							  NULL);

	if (!m_hWnd)
        return false;

    ShowWindow(m_hWnd, SW_SHOWDEFAULT);
    
	UpdateWindow(m_hWnd);
	SetFocus(m_hWnd);

	///////////////////////////////////////////////////////////////////////////
	m_hDC = ::GetDC(m_hWnd);
	if (!m_hDC)
		return false;

	// Setup PriorityClass
  	//HANDLE hProc = GetCurrentProcess();
    //SetPriorityClass(hProc, IDLE_PRIORITY_CLASS);
    //SetPriorityClass(hProc, NORMAL_PRIORITY_CLASS);
    //SetPriorityClass(hProc, REALTIME_PRIORITY_CLASS);
    //SetPriorityClass(hProc, HIGH_PRIORITY_CLASS);

	return true;
}

