// Image.h: interface for the CImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IMAGE_H__B67B7B8E_7604_4439_955B_76E777B5EAC7__INCLUDED_)
#define AFX_IMAGE_H__B67B7B8E_7604_4439_955B_76E777B5EAC7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Unknown.h"

class CImage : public CUnknown  
{
public:
	typedef enum _FORMAT
	{
		FMT_RGB,
		FMT_RGBA,
		FMT_COLOR_INDEX,
		FMT_LUMINANCE,

		FMT_DXT1,
		FMT_DXT3,
		FMT_DXT5,
	} FORMAT;

protected:
	FORMAT	m_format;
	DWORD	m_dwWidth, m_dwHeight;

	LPBYTE  m_pPalBuffer;

	LPBYTE  m_pBuffer;
	DWORD	m_dwBufferLength;

	bool	m_bCompressed;

public:
	CImage();
	virtual ~CImage();

	virtual void Destroy();

	virtual bool Create(DWORD dwWidth, DWORD dwHeight, FORMAT format);
	virtual bool Load(LPSTR lpszFileName);

	virtual void Mirror();
	virtual void Flip();

	virtual bool CompressS3TC(FORMAT format);

	// inline
	///////////////////////////////////////////////////////////////////////////
	FORMAT GetFormat()			{ return m_format; }

	DWORD  GetWidth()			{ return m_dwWidth; }
	DWORD  GetHeight()			{ return m_dwHeight; }

	LPBYTE GetBuffer()			{ return m_pBuffer; }
	DWORD  GetBufferLength()	{ return m_dwBufferLength; }

	LPBYTE GetPalBuffer()		{ return m_pPalBuffer; }
};

#endif // !defined(AFX_IMAGE_H__B67B7B8E_7604_4439_955B_76E777B5EAC7__INCLUDED_)
