// TGAImage.h: interface for the CTGAImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TGAIMAGE_H__C1909BE9_489C_4CAA_9948_75D2891DFBE4__INCLUDED_)
#define AFX_TGAIMAGE_H__C1909BE9_489C_4CAA_9948_75D2891DFBE4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Image.h"

// The image type.
#define TGA_TYPE_MAPPED		1
#define TGA_TYPE_COLOR		2
#define TGA_TYPE_GRAY		3
#define TGA_TYPE_MAPPED_RLE 9
#define TGA_TYPE_COLOR_RLE	10
#define TGA_TYPE_GRAY_RLE	11

/* Image descriptor.
   3-0: attribute bpp
   4:   left-to-right ordering
   5:   top-to-bottom ordering
   7-6: zero
*/
#define TGA_DESC_ABITS		0x0f
#define TGA_DESC_HORIZONTAL 0x10
#define TGA_DESC_VERTICAL	0x20

class CTGAImage : public CImage  
{
private:
	#pragma pack(push, 1)
	typedef struct _TGAFILEHEADER
	{
		char	idLength;
		char	colorMapType;
		char	imageType;
		WORD	colorMapIndex;
		WORD	colorMapLength;
		char	colorMapSize;
		WORD	firstX;
		WORD	firstY;
		WORD	width;
		WORD	height;
		char	bits;
		char	descriptor;
	} TGAFILEHEADER;
	#pragma pack(pop)

public:
	CTGAImage();
	virtual ~CTGAImage();

	bool Load(LPSTR lpszFileName);
};

#endif // !defined(AFX_TGAIMAGE_H__C1909BE9_489C_4CAA_9948_75D2891DFBE4__INCLUDED_)
