// Unknown.cpp: implementation of the CUnknown class.
//
//////////////////////////////////////////////////////////////////////

#include "Unknown.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUnknown::CUnknown()
{
	m_pszClassName = "CUnknown";
	m_pszName = NULL;

	m_pNext = NULL;
}

CUnknown::~CUnknown()
{
	Destroy();
}

void CUnknown::Destroy()
{
	if (m_pszName)
	{
		delete [] m_pszName;
		m_pszName = NULL;
	}

	if (m_pNext)
	{
		delete m_pNext;
		m_pNext = NULL;
	}
}

bool CUnknown::Create(LPSTR lpszName)
{
	int nLength = strlen(lpszName);

	m_pszName = new char [nLength+1];
	if (!m_pszName)
		return false;

	memcpy(m_pszName, lpszName, nLength);
	m_pszName[nLength] = 0;

	return true;
}

//
CUnknown* CUnknown::Find(DWORD dwUID)
{
	CUnknown* pNext = this;
	while (pNext)
	{
		if (pNext->GetUID(), dwUID)
			break;

		pNext = pNext->GetNext();
	}

	return pNext;
}
CUnknown* CUnknown::Find(LPSTR lpszName)
{
	CUnknown* pNext = this;
	while (pNext)
	{
		if (!strcmp(pNext->GetName(), lpszName))
			break;

		pNext = pNext->GetNext();
	}

	return pNext;
}

void CUnknown::SetLast(CUnknown* lpUnknown)
{
	CUnknown* pLast = this;
	while (1)
	{
		if (!pLast->GetNext())
		{
			pLast->SetNext(lpUnknown);
			break;
		}

		pLast = pLast->GetNext();
	}
}

CUnknown* CUnknown::GetLast()
{
	CUnknown* pLast = this;
	while (1)
	{
		if (!pLast->GetNext())
			break;

		pLast = pLast->GetNext();
	}

	return pLast;
}

