// Unknown.h: interface for the CUnknown class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UNKNOWN_H__98C5CD13_9DCD_4184_A16F_C5D71AD2F332__INCLUDED_)
#define AFX_UNKNOWN_H__98C5CD13_9DCD_4184_A16F_C5D71AD2F332__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <math.h>
#include <stdio.h>

// STRICT is the only supported option (NOSTRICT is no longer supported)
#ifndef STRICT
#define STRICT 1
#endif

#include <windows.h>

#if defined(WIN32)
	#if defined(_USRDLL)
		#define LIBAPI __declspec(dllexport)
	#else
		#define LIBAPI __declspec(dllimport)
	#endif
#else
	#define LIBAPI
#endif


typedef short far	*LPSHORT;

class CUnknown  
{
protected:
	LPSTR		m_pszClassName;

	DWORD		m_dwUID;
	LPSTR		m_pszName;

	CUnknown*	m_pNext;

public:
	CUnknown();
	virtual ~CUnknown();

	virtual void Destroy();

	virtual bool Create(LPSTR lpszName);

	virtual CUnknown* Find(DWORD dwUID);
	virtual CUnknown* Find(LPSTR lpszName);

	virtual CUnknown* GetLast();
	virtual void      SetLast(CUnknown* lpUnknown);

	// inline
	///////////////////////////////////////////////////////////////////////////
	LPSTR GetClassName()	{ return m_pszClassName; }

	DWORD GetUID()			{ return m_dwUID; }
	LPSTR GetName()			{ return m_pszName; }

	CUnknown* GetNext()					{ return m_pNext; }
	void      SetNext(CUnknown* lpNext)	{ m_pNext = lpNext; }
};

#endif // !defined(AFX_UNKNOWN_H__98C5CD13_9DCD_4184_A16F_C5D71AD2F332__INCLUDED_)
