// CountNodesTEP.cpp: implementation of the CCountNodesTEP class.
//
//////////////////////////////////////////////////////////////////////

#include "CountNodesTEP.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCountNodesTEP::CCountNodesTEP()
{
	m_nNodeCounts = 0;
}

CCountNodesTEP::~CCountNodesTEP()
{

}

int CCountNodesTEP::callback(INode *lpNode)
{
	INode* pNode = lpNode;
	if (pNode->IsRootNode())
		return TREE_ABORT;

	if (::FUndesirableNode(pNode))
	{
		// Mark as skippable
		::SetIndexOfINode(pNode, UNDESIRABLE_NODE_MARKER);
		return TREE_CONTINUE;
	}
	
	// Establish "node index"--just ascending ints
	::SetIndexOfINode(pNode, m_nNodeCounts);

	m_nNodeCounts ++;

	return TREE_CONTINUE;
}
