// ExportClass.h: interface for the CExportClass class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_EXPORTCLASS_H__3B4FAF58_3671_483A_9810_8F90284A19D4__INCLUDED_)
#define AFX_EXPORTCLASS_H__3B4FAF58_3671_483A_9810_8F90284A19D4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MAXSDK.h"

class CExportClass : public SceneExport  
{
public:
	static HWND m_hParams;

public:
	CExportClass();
	virtual ~CExportClass();

	int ExtCount();							// Number of extensions supported
	const TCHAR* Ext(int n);				// Extension #n (i.e. "3DS")
	const TCHAR* LongDesc();				// Long ASCII description (i.e. "Autodesk 3D Studio File")
	const TCHAR* ShortDesc();				// Short ASCII description (i.e. "3D Studio")
	const TCHAR* AuthorName();				// ASCII Author name
	const TCHAR* CopyrightMessage();		// ASCII Copyright message
	const TCHAR* OtherMessage1();			// Other message #1
	const TCHAR* OtherMessage2();			// Other message #2
	unsigned int Version();					// Version number * 100 (i.e. v3.01 = 301)
	void ShowAbout(HWND hWnd);				// Show DLL's "About..." box

	BOOL SupportsOptions(int nExt, DWORD dwOptions);
	int DoExport(const TCHAR* lpszFileName, ExpInterface* lpEI, Interface* lpI, BOOL bSuppressPrompts=FALSE, DWORD dwOptions=0);

};

#endif // !defined(AFX_EXPORTCLASS_H__3B4FAF58_3671_483A_9810_8F90284A19D4__INCLUDED_)
