// KINECollectNodesTEP.cpp: implementation of the CKINECollectNodesTEP class.
//
//////////////////////////////////////////////////////////////////////

#include "KINECollectNodesTEP.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#include "KINEExportClass.h"

CKINECollectNodesTEP::CKINECollectNodesTEP()
{

}

CKINECollectNodesTEP::~CKINECollectNodesTEP()
{

}

int CKINECollectNodesTEP::callback(INode *lpNode)
{
	INode* pNode = lpNode;
	if (pNode->IsRootNode())
		return TREE_ABORT;

	if (::FNodeMarkedToSkip(pNode))
		return TREE_CONTINUE;

	// Get pre-stored "index"
	int nNode = ::GetIndexOfINode(pNode);

	///////////////////////////////////////////////////////////////////////////////////////////////
	CKINEExportClass* pExportClass = (CKINEExportClass*) m_pExportClass;

	CMaxNodeKey* pMaxNodeKey = pExportClass->GetKeyFrame()->GetNodeKey(nNode);
	if (!pMaxNodeKey)
		return TREE_ABORT;

	// Get name, store name in array
	if (!pMaxNodeKey->Create(pNode->GetName()))
		return TREE_ABORT;

	return TREE_CONTINUE;
}
