// KINEDumpNodesTEP.cpp: implementation of the CKINEDumpNodesTEP class.
//
//////////////////////////////////////////////////////////////////////

#include "KINEDumpNodesTEP.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#include "KINEExportClass.h"

CKINEDumpNodesTEP::CKINEDumpNodesTEP()
{

}

CKINEDumpNodesTEP::~CKINEDumpNodesTEP()
{

}

int CKINEDumpNodesTEP::callback(INode *lpNode)
{
	INode* pNode = lpNode;
	if (pNode->IsRootNode())
		return TREE_ABORT;

	if (::FNodeMarkedToSkip(pNode))
		return TREE_CONTINUE;

	// Get node's parent
	INode* pParentNode = pNode->GetParentNode();
	BOOL bRootNode = pParentNode->IsRootNode();

	// Get pre-stored "index"
	int nNode = ::GetIndexOfINode(pNode);
	int nParentNode = ::GetIndexOfINode(pParentNode, !bRootNode);

	// Convenient time to cache this
	CKINEExportClass* pExportClass = (CKINEExportClass*) m_pExportClass;
	CMaxNodeKey* pMaxNodeKey = pExportClass->GetKeyFrame()->GetNodeKey(nNode);
	if (!pMaxNodeKey)
		return TREE_ABORT;

	pMaxNodeKey->SetParent(bRootNode ? UNDESIRABLE_NODE_MARKER : nParentNode);

	// Root node has no parent, thus no translation
	if (bRootNode)
		pMaxNodeKey->SetParent(-1);

	return TREE_CONTINUE;
}