// KINEExportClass.h: interface for the CKINEExportClass class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KINEEXPORTCLASS_H__4B76EEAA_9FF8_4161_992F_580F0C13F570__INCLUDED_)
#define AFX_KINEEXPORTCLASS_H__4B76EEAA_9FF8_4161_992F_580F0C13F570__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\ExportClass.h"

#include "..\MaxKeyFrame.h"

class CKINEExportClass : public CExportClass  
{
public:
	// Animation metrics (gleaned from 3dsMax and cached for convenience)
	Interval	m_IntervalOfAnimation;

	TimeValue	m_tvStart;
	TimeValue	m_tvEnd;

protected:
	CMaxKeyFrame*	m_pKeyFrame;

public:
	CKINEExportClass();
	virtual ~CKINEExportClass();

	void Destroy();
	
	int ExtCount();
	const TCHAR* Ext(int n);

	const TCHAR* LongDesc();
	const TCHAR* ShortDesc();

	int DoExport(const TCHAR* lpszFileName, ExpInterface* lpEI, Interface* lpI, BOOL bSuppressPrompts=FALSE, DWORD dwOptions=0);

	// inline
	///////////////////////////////////////////////////////////////////////////
	CMaxKeyFrame* GetKeyFrame()		{ return m_pKeyFrame; }

protected:
	BOOL DumpRotations(ExpInterface* lpExpInterface);
	BOOL CollectNodes(ExpInterface* lpExpInterface);
	BOOL DumpNodes(ExpInterface* lpExpInterface);
};

#endif // !defined(AFX_KINEEXPORTCLASS_H__4B76EEAA_9FF8_4161_992F_580F0C13F570__INCLUDED_)
