// MAXSDK.h: interface for the MAXSDK class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAXSDK_H__88B1009C_72A5_411F_913F_550111734238__INCLUDED_)
#define AFX_MAXSDK_H__88B1009C_72A5_411F_913F_550111734238__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Max.h"
#include "istdplug.h"

#include "decomp.H"
#include "stdmat.H"
#include "animtbl.H"

#include "iparamb2.h"
#include "iparamm2.h"

#include "phyexp.h"

// RESOURCE.H
#define IDS_LIBDESCRIPTION              1
#define IDS_CATEGORY                    2
#define IDS_CLASS_NAME                  3
#define IDS_PARAMS                      4

extern HINSTANCE hInstance;


TCHAR* GetString(int nId);
void MESSAGE(const char* lpszText);


Modifier* FindPhysiqueModifier(INode* lpNode);
BOOL FUndesirableNode(INode* lpNode);


/*
	NodeNode List
*/

#define MAX_NAME	256

// INode mapping table
typedef struct tagINODEINDEX
{
	char	szNodeName[MAX_NAME];
	int		nIndex;
} INODEINDEX, *LPINODEINDEX;


#define UNDESIRABLE_NODE_MARKER	(-127)

void CreateINodeIndex();
void ReleaseINodeIndex();

int  GetIndexOfINode(INode* lpNode, BOOL bAssertPropExists = TRUE);
void SetIndexOfINode(INode* lpNode, int nIndex);

BOOL FUndesirableNode(INode* lpNode);
BOOL FNodeMarkedToSkip(INode* lpNode);

float FlReduceRotation(float fl);

#endif // !defined(AFX_MAXSDK_H__88B1009C_72A5_411F_913F_550111734238__INCLUDED_)
