// MaxKeyFrame.cpp: implementation of the CMaxKeyFrame class.
//
//////////////////////////////////////////////////////////////////////

#include "MaxKeyFrame.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMaxKeyFrame::CMaxKeyFrame()
{
	m_pNodeKeys = NULL;

	m_dwNumNodeKeys = 0;
	m_dwNumFrames = 0;

	m_dwTicksPerFrame = 0;
}

CMaxKeyFrame::~CMaxKeyFrame()
{
}

bool CMaxKeyFrame::CreateKeys(DWORD dwNumKeys)
{
	m_pNodeKeys = new CMaxNodeKey [dwNumKeys];
	if (!m_pNodeKeys)
		return false;

	m_dwNumNodeKeys = dwNumKeys;

	return true;
}

bool CMaxKeyFrame::Save(LPSTR lpszFileName)
{
	CFileStream stream;
	if (!stream.Open(lpszFileName, CFileStream::CREATE))
		return false;

	WriteHeader(&stream);

	///////////////////////////////////////////////////////////////////////////////////////////////
	stream.Write(&m_dwNumNodeKeys, sizeof(DWORD), 1);

	///////////////////////////////////////////////////////////////////////////////////////////////
	stream.Write(&m_dwTicksPerFrame, sizeof(DWORD), 1);
	stream.Write(&m_dwNumFrames, sizeof(DWORD), 1);

	CMaxNodeKey* pNodeKey = (CMaxNodeKey*) m_pNodeKeys;
	for (int i=0; i<(int) m_dwNumNodeKeys; i++)
	{
		pNodeKey->Write(&stream, m_dwNumFrames);

		pNodeKey ++;
	}

	return true;
}

void CMaxKeyFrame::WriteHeader(CFileStream* lpStream)
{
	CFileStream* pStream = lpStream;

	// Write file header
	pStream->WriteString("RIFF");

	DWORD dwVersion = 100;
	pStream->Write(&dwVersion, sizeof(DWORD), 1);
}