// MaxMaterial.cpp: implementation of the CMaxMaterial class.
//
//////////////////////////////////////////////////////////////////////

#include "MaxMaterial.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMaxMaterial::CMaxMaterial()
{
	m_pszTexureName = NULL;
}

CMaxMaterial::~CMaxMaterial()
{
	Destroy();
}

void CMaxMaterial::Destroy()
{
	if (m_pszTexureName)
	{
		delete [] m_pszTexureName;
		m_pszTexureName = NULL;
	}

	CMaterial::Destroy();
}

bool CMaxMaterial::SelectTexture(LPSTR lpszName)
{
	int nLength = strlen(lpszName);
	m_pszTexureName = new char [nLength+1];
	if (!m_pszTexureName)
		return false;

	memcpy(m_pszTexureName, lpszName, nLength);
	m_pszTexureName[nLength] = 0;

	return true;	
}

void CMaxMaterial::Write(CFileStream *lpStream)
{
	CFileStream* pStream = lpStream;

	pStream->WriteString(m_pszName);

	pStream->Write(&m_ambient, sizeof(COLOR), 1);
	pStream->Write(&m_diffuse, sizeof(COLOR), 1);
	pStream->Write(&m_specular, sizeof(COLOR), 1);

	pStream->Write(&m_shininess, sizeof(float), 1);

	pStream->WriteString(m_pszTexureName);
}
