// MaxMesh.h: interface for the CMaxMesh class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAXMESH_H__D0E5B99F_5CEE_462A_999D_E75C7149D48C__INCLUDED_)
#define AFX_MAXMESH_H__D0E5B99F_5CEE_462A_999D_E75C7149D48C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Rasterizer\Mesh.h"
#include "..\Rasterizer\MathLibrary.h"

#include "MaxMaterial.h"
#include "MaxMeshFace.h"

class CMaxMesh : public CMesh  
{
public:
	VECTOR3D	m_translate;			// default translate
	QUATERNION	m_quaternion;

	// For calc matrix
	MATRIX		m_im;

protected:
	CMaxMeshFace*	m_pMeshFace;

public:
	CMaxMesh();
	virtual ~CMaxMesh();

	void Write(CFileStream* lpStream);

	bool LookupVertex(LPVERTEX lpVertex, int nNode = -1);
	bool LookupMaterial(CMaxMaterial* lpMaterial);
};

#endif // !defined(AFX_MAXMESH_H__D0E5B99F_5CEE_462A_999D_E75C7149D48C__INCLUDED_)
