// MaxMeshFace.cpp: implementation of the CMaxMeshFace class.
//
//////////////////////////////////////////////////////////////////////

#include "MaxMeshFace.h"

#include "MaxKernel.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMaxMeshFace::CMaxMeshFace()
{
	m_dwIndex = 0;
	m_pFace = NULL;

	m_dwNumFaces = 0;
}

CMaxMeshFace::~CMaxMeshFace()
{
}

bool CMaxMeshFace::Append()
{
	m_dwNumFaces ++;

	// Copy Material
	m_pFace = new CMaxFace;
	if (!m_pFace)
		return false;

	if (!m_pFace->Append())
		return false;

	// Insert Material
	if (!m_pFaces)
		m_pFaces = m_pFace;
	else
	{
		CMaxFace* pFace = (CMaxFace*) m_pFaces;
		pFace->SetLast(m_pFace);
	}

	return true;
}

void CMaxMeshFace::Append(DWORD dwIndex)
{
	m_pFace->Append(dwIndex);
}

void CMaxMeshFace::Write(CFileStream *lpStream)
{
	CFileStream* pStream = lpStream;

	CMaxMaterial* pMaterial = CMaxKernel::LookupMaterial(m_dwIndex);
	if (!pMaterial)
		return;

	pStream->WriteString(pMaterial->GetName());

	///////////////////////////////////////////////////////////////////////////////////////////////
	pStream->Write(&m_dwNumFaces, sizeof(DWORD), 1);

	CMaxFace* pNext = (CMaxFace*) m_pFaces;
	for (int i=0; i<(int) m_dwNumFaces; i++)
	{
		pNext->Write(pStream);
		pNext = (CMaxFace*) pNext->GetNext();
	}
}
