// MaxMeshFrame.h: interface for the CMaxMeshFrame class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAXMESHFRAME_H__BFF18FE8_8EC7_4FE9_BC0D_5629F0706BFB__INCLUDED_)
#define AFX_MAXMESHFRAME_H__BFF18FE8_8EC7_4FE9_BC0D_5629F0706BFB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Rasterizer\MeshFrame.h"

#include "MaxMesh.h"
#include "MaxKeyNode.h"

typedef struct _KEYNODEFIXUP
{
	// for calc matrix
	MATRIX		m, im;
	VECTOR3D	world;
} KEYNODEFIXUP, *LPKEYNODEFIXUP;

class CMaxMeshFrame : public CMeshFrame  
{
protected:
	void WriteHeader(CFileStream* lpStream);

public:
	LPKEYNODEFIXUP	m_pKeyNodeFixup;

public:
	CMaxMeshFrame();
	virtual ~CMaxMeshFrame();

	void Destroy();
	
	bool CreateNodes(DWORD dwNumNodes);

	bool Save(LPSTR lpszFileName);
	bool SaveMeshFrames(LPSTR lpszFileName);

	void BuildReference();

	CMaxMesh* LookupMesh(LPSTR lpszName);

	// inline
	///////////////////////////////////////////////////////////////////////////
	CMaxKeyNode*    GetKeyNode(DWORD dwNode)		{ return (CMaxKeyNode*) m_pKeyNodes + dwNode; }
	LPKEYNODEFIXUP  GetKeyNodeFixup(DWORD dwNode)	{ return m_pKeyNodeFixup + dwNode; }
};

#endif // !defined(AFX_MAXMESHFRAME_H__BFF18FE8_8EC7_4FE9_BC0D_5629F0706BFB__INCLUDED_)
