// MaxKey.cpp: implementation of the CMaxKey class.
//
//////////////////////////////////////////////////////////////////////

#include "MaxNodeKey.h"

#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMaxNodeKey::CMaxNodeKey()
{
	m_nParent = UNDESIRABLE_NODE_MARKER;	
}

CMaxNodeKey::~CMaxNodeKey()
{
}

bool CMaxNodeKey::CreateFrames(DWORD dwNumFrames)
{
	m_pKinematics = new KINEMATICS [dwNumFrames];
	if (!m_pKinematics)
		return false;

	return true;
}

void CMaxNodeKey::Write(CFileStream *lpStream, DWORD dwNumFrames)
{
	CFileStream* pStream = lpStream;

	pStream->WriteString(m_pszName);

	pStream->Write(&m_nParent, sizeof(int), 1);
	pStream->Write(m_pKinematics, sizeof(KINEMATICS), dwNumFrames);
}
