// MESHCollectNodesTEP.cpp: implementation of the CMESHCollectNodesTEP class.
//
//////////////////////////////////////////////////////////////////////

#include "MESHCollectNodesTEP.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#include "MESHExportClass.h"

CMESHCollectNodesTEP::CMESHCollectNodesTEP()
{

}

CMESHCollectNodesTEP::~CMESHCollectNodesTEP()
{

}

int CMESHCollectNodesTEP::callback(INode *lpNode)
{
	INode* pNode = lpNode;
	if (pNode->IsRootNode())
		return TREE_ABORT;

	if (::FNodeMarkedToSkip(pNode))
		return TREE_CONTINUE;

	// Get pre-stored "index"
	int nNode = ::GetIndexOfINode(pNode);

	///////////////////////////////////////////////////////////////////////////////////////////////
	CMESHExportClass* pExportClass = (CMESHExportClass*) m_pExportClass;

	CMaxKeyNode* pMaxKeyNode = pExportClass->GetMeshFrame()->GetKeyNode(nNode);
	if (!pMaxKeyNode)
		return TREE_ABORT;

	// Get name, store name in array
	if (!pMaxKeyNode->Create(pNode->GetName()))
		return TREE_ABORT;

	return TREE_CONTINUE;
}


