// MESHExportClass.h: interface for the CMESHExportClass class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MESHEXPORTCLASS_H__16100227_52D5_4B1B_AE47_D1265A9AE40D__INCLUDED_)
#define AFX_MESHEXPORTCLASS_H__16100227_52D5_4B1B_AE47_D1265A9AE40D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\ExportClass.h"

#include "..\MaxMeshFrame.h"

class CMESHExportClass : public CExportClass  
{
public:
	// Animation metrics (gleaned from 3dsMax and cached for convenience)
	Interval	m_IntervalOfAnimation;

	TimeValue	m_tvStart;
	TimeValue	m_tvEnd;

protected:
	CMaxMeshFrame*	m_pMeshFrame;

public:
	CMESHExportClass();
	virtual ~CMESHExportClass();

	void Destroy();
	
	int ExtCount();
	const TCHAR* Ext(int n);

	const TCHAR* LongDesc();
	const TCHAR* ShortDesc();

	int DoExport(const TCHAR* lpszFileName, ExpInterface* lpEI, Interface* lpI, BOOL bSuppressPrompts=FALSE, DWORD dwOptions=0);

	// inline
	///////////////////////////////////////////////////////////////////////////
	CMaxMeshFrame* GetMeshFrame()		{ return m_pMeshFrame; }

protected:
	BOOL DumpMesh(ExpInterface* lpExpInterface);
	BOOL CollectNodes(ExpInterface* lpExpInterface);
	BOOL DumpNodes(ExpInterface* lpExpInterface);
};

#endif // !defined(AFX_MESHEXPORTCLASS_H__16100227_52D5_4B1B_AE47_D1265A9AE40D__INCLUDED_)
