// Camera.cpp: implementation of the CCamera class.
//
//////////////////////////////////////////////////////////////////////

#include "Camera.h"

#include "OpenGL.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCamera::CCamera()
{
	m_pszClassName = "CCamera";

	///////////////////////////////////////////////////////////////////////////
	Reset();
}

CCamera::~CCamera()
{

}

void CCamera::Reset()
{
	m_position.x = 0.0f;
	m_position.y = 0.0f;
	m_position.z = 5;

	m_rotate.x = 0.0f;
	m_rotate.y = 0.0f;
	m_rotate.z = 0.0f;
}

void CCamera::Apply()
{
	//glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	// Do Translations
	glTranslatef(-m_position.x, -m_position.y, -m_position.z);

	// Do Ratations
	glRotatef(m_rotate.x, 1.0f, 0.0f, 0.0f);
	glRotatef(m_rotate.y, 0.0f, 1.0f, 0.0f);
	glRotatef(m_rotate.z, 0.0f, 0.0f, 1.0f);
}
