// Face.cpp: implementation of the CFace class.
//
//////////////////////////////////////////////////////////////////////

#include "Face.h"

#include "OpenGL.h"
#include "..\Common\FileStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFace::CFace()
{
	m_pszClassName = "CFace";

	///////////////////////////////////////////////////////////////////////////
	m_pIndices = NULL;
}

CFace::~CFace()
{
	Destroy();
}

void CFace::Destroy()
{
	if (m_pIndices)
	{
		delete [] m_pIndices;
		m_pIndices = NULL;
	}
}

bool CFace::Read(CFileStream* lpStream)
{
	CFileStream* pStream = lpStream;

	///////////////////////////////////////////////////////////////////////////////////////////////
	pStream->Read(&m_dwNumIndices, sizeof(DWORD), 1);

	m_pIndices = new DWORD [m_dwNumIndices];
	if (!m_pIndices)
		return false;

	pStream->Read(m_pIndices, sizeof(DWORD), m_dwNumIndices);

	return true;
}

void CFace::Render()
{
	glDrawElements(GL_TRIANGLES, m_dwNumIndices, GL_UNSIGNED_INT, m_pIndices);
}