// Font.h: interface for the CFont class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FONT_H__0726D7F1_6E76_4150_9C76_4985B612DA81__INCLUDED_)
#define AFX_FONT_H__0726D7F1_6E76_4150_9C76_4985B612DA81__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

class CFont : public CUnknown  
{
protected:
	DWORD			m_dwWidth, m_dwHeight;
	LPBYTE			m_pSurface;

	LPBITMAPINFO	m_pBMInfo;
	HBITMAP			m_hBitmap;
	HFONT			m_hFont;

	HDC				m_hMemDC;

	unsigned int	m_nName;

public:
	CFont();
	virtual ~CFont();

	virtual void Destroy();

	virtual bool Create(LPSTR lpszFontName, DWORD dwHeight);

	virtual void SetColor(DWORD dwColor);
	virtual void TextOutXY(int x, int y, LPSTR lpszText);

	virtual void TextOutXY(int x, int y, LPSTR lpszText, DWORD dwColor);
};

#endif // !defined(AFX_FONT0_H__0726D7F1_6E76_4150_9C76_4985B612DA81__INCLUDED_)
