// Kernel.h: interface for the CKernel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KERNEL_H__3CFB6452_9490_4825_84EE_420E57C461FE__INCLUDED_)
#define AFX_KERNEL_H__3CFB6452_9490_4825_84EE_420E57C461FE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

class CTexture;
class CMaterial;

class CFileStream;

class CKernel : public CUnknown
{
protected:
	static CMaterial*	m_pMaterial;
	static CTexture*	m_pTexture;

public:
	CKernel();
	virtual ~CKernel();

	static void Destroy();

	static bool	ReadMaterial(CFileStream* lpStream);

	static CTexture*	LookupTexture(LPSTR lpszName);
	static CMaterial*	LookupMaterial(LPSTR lpszName);

	// inline
	///////////////////////////////////////////////////////////////////////////
	static CMaterial* GetMaterial()		{ return m_pMaterial; }
	static CTexture*  GetTexture()		{ return m_pTexture; }
};

#endif // !defined(AFX_KERNEL_H__3CFB6452_9490_4825_84EE_420E57C461FE__INCLUDED_)
