// KeyFrame.h: interface for the CKeyFrame class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KEYFRAME_H__493A7FEA_7F87_4A2E_AAEC_3694699A626D__INCLUDED_)
#define AFX_KEYFRAME_H__493A7FEA_7F87_4A2E_AAEC_3694699A626D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Common\Unknown.h"

class CFileStream;
class CNodeKey;

class CKeyFrame : public CUnknown  
{
protected:
	DWORD		m_dwNumNodeKeys;
	CNodeKey*	m_pNodeKeys;

	DWORD		m_dwNumFrames;
	DWORD		m_dwTicksPerFrame;

	float		m_fCurrentFrame;
	float		m_fFramePerSecond;

protected:
	bool ReadHeader(CFileStream *lpStream);

public:
	CKeyFrame();
	virtual ~CKeyFrame();

	virtual void Destroy();

	virtual bool Load(LPSTR lpszFileName);

	virtual void AdvanceFrame(float dt);

	// inline
	///////////////////////////////////////////////////////////////////////////
	DWORD	  GetNumNodeKeys()	{ return m_dwNumNodeKeys; }
	CNodeKey* GetNodeKeys()		{ return m_pNodeKeys; }

	DWORD GetNumFrames()		{ return m_dwNumFrames; }

	DWORD GetTicksPerFrame()	{ return m_dwTicksPerFrame; }
	float GetCurrentFrame()		{ return m_fCurrentFrame; }

};

#endif // !defined(AFX_KEYFRAME_H__493A7FEA_7F87_4A2E_AAEC_3694699A626D__INCLUDED_)
